% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCNFeats.R
\name{extractCNFeats}
\alias{extractCNFeats}
\title{extractCNFeats}
\usage{
extractCNFeats(
  segData,
  gbuild = "hg19",
  cores = 1,
  featsToExtract = CNSigs::defaultFeats
)
}
\arguments{
\item{segData}{The copy number segment data}

\item{gbuild}{The reference genome build. Default is hg19. Also supports hg18 and hg38.}

\item{cores}{The number of cores to use for parallel processing. Default 1.}

\item{featsToExtract}{The names of the features to extract.}
}
\value{
list of dataframes containing results of six copy number features
}
\description{
This function is used to extract the six copy number features that are
eventually used in order to make the signatures. It does this using
six sub functions to extract each feature. Before extracting the features, 
the segments are passed through a validation function to make sure the data
is formatted correctly and there are no invalid segments.  Can be done in 
parallel using the cores parameter.
}
\examples{
extractCNFeats(segDataExp)
}
\keyword{bp10MB}
\keyword{bpchrarm}
\keyword{changepoint}
\keyword{features}
\keyword{osCN}
\keyword{segsize}
