% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iNEXTwrapper.R
\name{iNEXTwrapper}
\alias{iNEXTwrapper}
\title{Parallel estimation of species richness in a community using iNEXT}
\usage{
iNEXTwrapper(
  data = NULL,
  variableColumn = "groupVariable",
  valueColumn = "n",
  q = 0,
  datatype = "abundance",
  conf = 0.95,
  se = TRUE,
  nboot = 50,
  size = NULL,
  endpoint = NULL,
  knots = 40,
  mc.cores = 1
)
}
\arguments{
\item{data}{A data frame or tibble. A data frame containing "abundance"-type data per variable
(population, country, species...) in columns.}

\item{variableColumn}{Character. The column to be used to group the data. Probably "country"
or "site". Default =  "groupVariable".}

\item{valueColumn}{Character. The column containing the count data. Defualt =  "n".}

\item{q}{a number or vector specifying the richness order(s) of Hill numbers.}

\item{datatype}{data type of input data: individual-based abundance data
(datatype = "abundance"), sampling-unit-based incidence frequencies data
(datatype = "incidence_freq") or species by sampling-units incidence matrix
(datatype = "incidence_raw").}

\item{conf}{a positive number < 1 specifying the level of confidence interval; default is 0.95.}

\item{se}{a logical variable to calculate the bootstrap standard error and conf confidence
interval.}

\item{nboot}{an integer specifying the number of replications; default is 50.}

\item{size}{an integer vector of sample sizes (number of individuals or sampling units) for
which richness estimates will be computed. If NULL, then richness estimates will be computed
for those sample sizes determined by the specified/default endpoint and knots.}

\item{endpoint}{an integer specifying the sample size that is the endpoint for
rarefaction/extrapolation. If NULL, then endpoint = double the reference sample size.}

\item{knots}{an integer specifying the number of equally-spaced knots (say K, default is 40)
between size 1 and the endpoint; each knot represents a particular sample size for which
richness estimate will be calculated. If the endpoint is smaller than the reference sample
size, then iNEXT() computes only the rarefaction esimates for approximately K evenly spaced
knots. If the endpoint is larger than the reference sample size, then iNEXT() computes
rarefaction estimates for approximately K/2 evenly spaced knots between sample size 1 and
the reference sample size, and computes extrapolation estimates for approximately K/2 evenly
spaced knots between the reference sample size and the endpoint.}

\item{mc.cores}{Numeric. If > 1, the function will run in parallel
using mclapply using the number of cores specified. If = 1 then it will be run using a serial
loop. NOTE: Windows machines must use a value of 1 (see ?parallel::mclapply). Additionally,
be aware that each thread can use large chunks of memory.
Default = 1.}
}
\value{
Returns a list containing two tibbles. The first is a tibble that concatenates the outputs
from the basic data and rare species information in columns per input variable (column). The second is a tibble
that concatenates the various species richness estimates, with input variables in chunks of rows.
Additionally a console output will list the variables (columns) that lacked sufficient data
to be analysed.
}
\description{
A wrapper for \code{iNEXT::iNEXT()} to interpolate and extrapolate Hill numbers with order q
(rarify species richness). The wrapper has the ability to estimate species richness for
multiple sites (or countries) at once and to do this using multiple cores.
}
\examples{

\dontrun{
  # Read in some example data and use [BeeBDC::richnessPrepR()] to create the example input data
 #' data(beesCountrySubset)

estimateDataExample <- BeeBDC::richnessPrepR(
  data = beesCountrySubset,
  # Download the taxonomy
  taxonomyFile = BeeBDC::beesTaxonomy(),
  # Download the checklist
  checklistFile = BeeBDC::beesChecklist(),
  curveFunction = function(x) (228.7531 * x * x^-log(12.1593)),
  sampleSize = 10000,
  countryColumn = "country_suggested",
  limitGlobal = NULL,
  outPath = tempdir()
)

  # In this function we can directly feed in estimateDataExample$site_speciesCounts 
 iNextOut <- iNEXTwrapper(data = estimateDataExample$site_speciesCounts,
                          variableColumn = "country_suggested",
                          valueColumn = "n",
                          q = 0,
                          datatype = "abundance",
                          conf = 0.95,
                          se = TRUE,
                          nboot = 50,
                          size = NULL,
                          endpoint = NULL,
                          knots = 40,
                          mc.cores = 1)
}
}
\seealso{
\code{\link[iNEXT:iNEXT]{iNEXT::iNEXT()}}
}
