% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsSphere-functions.R
\name{knotsSimple}
\alias{knotsSimple}
\alias{dKnotsSimple}
\alias{rKnotsSimple}
\title{Dirichlet prior over knot locations on interval}
\usage{
dKnotsSimple(x, a, b, k, alpha, log = 0)

rKnotsSimple(n, a, b, k, alpha)
}
\arguments{
\item{x}{Numeric vector of length \eqn{K}; strictly increasing knot
locations in \eqn{[a,b]}.}

\item{a}{Numeric scalar. Lower bound of the interval.}

\item{b}{Numeric scalar. Upper bound of the interval.}

\item{k}{integer (scalar); number of internal knots \eqn{K}.}

\item{alpha}{numeric vector; first \eqn{K} elements are used as Dirichlet
parameters for the internal gaps.}

\item{log}{logical; If TRUE, probabilities p are given as log(p)}

\item{n}{Integer}
}
\value{
\itemize{
\item \code{dKnotsSimple()} returns a scalar numeric (density or log-density).
\item \code{rKnotsSimple()} returns a numeric vector of length \eqn{K} with ordered
knots in \eqn{(a,b)}. To register distribution for nimble, only one vector is generated.
}
}
\description{
\code{dKnotsSimple()} evaluates a Dirichlet-based prior for \emph{K} internal
knots \eqn{x_1 < \dots < x_K} on an interval \eqn{[a,b]} by placing a
Dirichlet distribution on the normalized gaps
\eqn{(x_1-a,\; x_2-x_1,\; \ldots,\; x_K-x_{K-1},\; b-x_K)/(b-a)}.
\code{rKnotsSimple()} draws one set of \emph{K} knots from the same construction
by first sampling the gap proportions and then taking the cumulative sum.
}
\details{
Let \eqn{K = k}. The prior uses parameters
\eqn{\alpha_{\text{full}} = (\alpha_1,\ldots,\alpha_K, 1)} so that the last
gap \eqn{b-x_K} receives a fixed weight of 1 while the \eqn{K} internal gaps
are controlled by \eqn{\alpha = (\alpha_1,\ldots,\alpha_K)}. Since these functions are for
choosing random knots initially, it may not appropriate for practical use.
}
\note{
This implementation forms the gaps, normalizes by \eqn{b-a}, and uses
\code{ddirch()}/\code{rdirch()} internally. Ensure \eqn{a<b}, \eqn{K\ge 1}, and that
\code{alpha} has at least \eqn{K} elements.
}
\keyword{internal}
