% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.f.test}
\alias{BF10.f.test}
\title{Bayes Factor for a Bayesian F-Test}
\usage{
BF10.f.test(fval, df1, df2, dff, rscale, f_m, prior_analysis, ROPE = NULL)
}
\arguments{
\item{fval}{Numeric scalar. Observed F statistic (must be at least 0).}

\item{df1}{Numeric scalar. Numerator degrees of freedom (must be > 0).}

\item{df2}{Numeric scalar. Denominator degrees of freedom (must be > 0).}

\item{dff}{Numeric scalar. Degrees of freedom for the analysis prior under
the alternative hypothesis. For the Moment prior, this must be \eqn{\ge 3}.}

\item{rscale}{Numeric scalar. Scale parameter for the effect-size prior
(only used when \code{prior_analysis = "effectsize"}).}

\item{f_m}{Numeric scalar. Cohen's f effect-size parameter for the
analysis prior.}

\item{prior_analysis}{character. Analysis prior under the
alternative hypothesis. Must be either \code{"effectsize"} or
\code{"Moment"}.}

\item{ROPE}{Numeric scaler. Optional numeric scalar specifying an upper bound for an interval
null hypothesis. If provided, must be > 0.}
}
\value{
A list of class \code{"BFvalue_f"} containing:
\describe{
\item{\code{fval}}{Input F-value.}
\item{\code{df1}, \code{df2}}{Degrees of freedom.}
\item{\code{ROPE}}{Interval bound (if specified).}
\item{\code{analysis_h1}}{List containing the analysis prior specification, including the prior distribution, the scale \code{rscale}, f \code{f_m}, and degrees of freedom \code{dff}.}
\item{\code{bf10}}{The computed Bayes factor.}
\item{\code{p.value}}{p-value.}
}
}
\description{
Computes the Bayes factor (BF10) for an F-test, comparing a full model to a
reduced model under either an effect-size prior or a Moment prior.
Optionally, an interval null hypothesis can be specified.
}
\examples{
BF10.f.test(
  fval = 4.5,
  df1 = 2,
  df2 = 12,
  dff = 12,
  rscale = 0.707,
  f_m = 0.1,
  prior_analysis = "effectsize"
)

}
