% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesPET.R
\name{get_oc}
\alias{get_oc}
\title{Generate operating characteristics for event prediction}
\usage{
get_oc(
  N,
  E_target,
  E_cutoff,
  p_trt,
  cov_type,
  cov_dist,
  logHR.trt = NULL,
  enroll_rate,
  dist.event,
  dist.censor,
  blinded = TRUE,
  event.scale = NULL,
  event.shape = NULL,
  censor.scale = NULL,
  censor.shape = NULL,
  beta.event,
  beta.censor,
  event.scale_trt = NULL,
  event.shape_trt = NULL,
  beta.event_trt = if (is.null(logHR.trt)) beta.event else NULL,
  assess_window = 0,
  seed = 123,
  hyperparams_enroll = list(),
  hyperparams_event = list(),
  hyperparams_censor = list(),
  chains = 4,
  iter = 4000,
  warmup = floor(iter/2),
  refresh = 0,
  control = list(list(adapt_delta = 0.95)),
  nsim = 1000,
  nsim.max = 3 * nsim,
  n_workers = 1,
  ...
)
}
\arguments{
\item{N}{Integer. Total planned sample size (maximum number of subjects
that can be enrolled in the trial).}

\item{E_target}{Integer. Target number of events for the final analysis.}

\item{E_cutoff}{Integer. Target number of events for the interim analysis.}

\item{p_trt}{Scalar randomization probability to the experimental arm, \eqn{\gamma \in (0,1)}.}

\item{cov_type}{Character vector specifying the distribution for each component
of the covariate vector \eqn{\boldsymbol{Z} = (Z_1,\dots,Z_p)} used in the
proportional hazards  model.
Each element must be \code{"binary"} or \code{"continuous"}.
If \code{NULL}, no covariates are used.}

\item{cov_dist}{Numeric vector of the same length as \code{cov_type}, giving
parameters for the covariate-generating distribution of each \eqn{Z_j}:
\itemize{
\item \code{"binary"}: \eqn{Z_j \sim \mathrm{Bernoulli}(p_j)} with
\eqn{p_j = cov\_dist[j]}.
\item \code{"continuous"}: \eqn{Z_j \sim N(0, \sigma_j^2)} with
\eqn{\sigma_j = cov\_dist[j]}.
}}

\item{logHR.trt}{Numeric scalar giving the log hazard ratio for the experimental
versus control arm in the event-time model. When \code{NULL} (default), the two treatment
arms are generated from separate proportional hazards models with
arm-specific baseline parameters and covariate effects.}

\item{enroll_rate}{Positive numeric scalar specifying the enrollment rate.}

\item{dist.event}{Character. Baseline distribution for event times:
\code{"Weibull"} or \code{"Loglogistic"}. This distribution family is the same
for both arms.}

\item{dist.censor}{Character. Baseline distribution for random censoring times:
\code{"Weibull"} or \code{"Loglogistic"}.}

\item{blinded}{Logical. If \code{TRUE} (default), the generated interim dataset is blinded
and treatment assignments in \code{data.eventcensor$trt} are set to \code{NA}.
If \code{FALSE}, treatment assignments in \code{data.eventcensor$trt} are coded as \code{0} for
control and \code{1} for the experimental group.}

\item{event.scale}{Numeric scalar > 0. Control-arm event baseline scale parameter.}

\item{event.shape}{Numeric scalar > 0. Control-arm event baseline shape parameter.}

\item{censor.scale}{Numeric scalar > 0. Random censoring baseline scale parameter.}

\item{censor.shape}{Numeric scalar > 0. Random censoring baseline shape parameter.}

\item{beta.event}{Numeric vector. Regression coefficients for baseline
covariates in the event-time proportional hazards model; must have the
same length and ordering as \code{cov_type}.}

\item{beta.censor}{Numeric vector. Regression coefficients for baseline
covariates in the random censoring-time proportional hazards model; must
have the same length and ordering as \code{cov_type}.}

\item{event.scale_trt}{Numeric scalar > 0. Experimental-arm event
baseline scale parameter (used when \code{logHR.trt = NULL}). Defaults to \code{NULL}.}

\item{event.shape_trt}{Numeric scalar > 0. Experimental-arm event baseline shape parameter
(used when \code{logHR.trt = NULL}). Defaults to \code{NULL}.}

\item{beta.event_trt}{Numeric vector. Regression coefficients for baseline
covariates in the experimental-arm event-time proportional hazards model, used when
\code{logHR.trt = NULL}. Must
have the same length and ordering as \code{cov_type}. Defaults to \code{beta.event}.}

\item{assess_window}{Numeric scalar >= 0. Assessment window width. If > 0,
observed event/censoring times are coarsened to the midpoint of the window
containing \eqn{\min(T_\mathrm{event}, T_\mathrm{censor})}. Defaults to \code{0}.}

\item{seed}{Integer. Base random seed used to generate simulated datasets.
Replicate \code{i} uses seed \code{seed + i - 1}. Defaults to \code{123}.}

\item{hyperparams_enroll}{List of prior hyperparameters for the enrollment model.
See \code{\link{fit_models}} for details.}

\item{hyperparams_event}{List of prior hyperparameters for the event-time model.
See \code{\link{fit_models}} for details.}

\item{hyperparams_censor}{List of prior hyperparameters for the censoring model.
See \code{\link{fit_models}} for details.}

\item{chains}{Number of Markov chain Monte Carlo (MCMC) chains. Defaults to \code{4}.}

\item{iter}{Number of iterations per chain (including warmup). Defaults to \code{4000}.}

\item{warmup}{Number of warmup (burn-in) iterations per chain. Must be strictly smaller
than \code{iter}. Defaults to \code{floor(iter / 2)}.}

\item{refresh}{Frequency of progress updates from \code{\link[rstan]{sampling}}. Set to \code{0} (default) to suppress output.}

\item{control}{Sampler control settings passed to \code{\link[rstan]{sampling}} for the three
submodels (enrollment, censoring, and event-time).
Can be specified as:
\itemize{
\item a single named list of control parameters (shared across all
three submodels), or
\item a list of up to three named lists, recycled to length 3, giving
separate control settings for the enrollment, censoring, and
event-time models, respectively.
}
Typical entries include \code{adapt_delta} and \code{max_treedepth}.

Defaults to \code{list(list(adapt_delta = 0.95))}.}

\item{nsim}{Integer. Number of valid simulated trial replicates used to compute
operating characteristics. Defaults to \code{1000}.}

\item{nsim.max}{Integer. Maximum number of simulated datasets to attempt in order
to obtain \code{nsim} valid replicates (i.e., replicates that can reach \code{E_target}).
Defaults to \code{3*n.sim}.}

\item{n_workers}{Integer or \code{NULL}. Number of parallel workers used by the 'future'
backend. If \code{NULL}, defaults to one fewer than the number of available
CPU cores.}

\item{\dots}{Additional arguments passed to \code{\link[furrr]{future_map}}.
These can be used to control parallel execution behavior (e.g.,
scheduling, chunk size, or progress reporting) and do not affect
data generation or model fitting.}
}
\value{
An object of class \code{"BayesPET_oc"} containing operating
characteristics for event-time prediction, based on simulated trial
replicates for which the target number of events \code{E_target} is reachable.
The object is a named list with components:
\itemize{
\item \code{replicate}: A data frame with one row per retained (valid) simulated trial
replicate. Columns include:
\itemize{
\item \code{median}: Median of the posterior predictive draws of the
calendar time at which \code{E_target} events are reached.
\item \code{cuttime.true}: True calendar time at which the cumulative number
of observed events in the simulated trial first reaches \code{E_target}.
\item \code{difference}: Absolute prediction error,
\code{abs(median - cuttime.true)}.
}
\item \code{n_valid}: Number of retained replicates.
\item \code{n_attempt}: Total number of simulated datasets attempted.
\item \code{nsim_target}: Target number of replicates requested.
\item \code{nsim_max}: Maximum number of datasets that may be generated.
\item \code{seed0}: Base random seed used to generate simulated datasets;
equals the input argument \code{seed}.
\item \code{seeds}: Integer vector of seeds corresponding to the retained
replicates (one per row of \code{replicate}).
\item \code{call}: Matched function call.
}
}
\description{
Generate operating characteristics for multiple simulated trials
}
\details{
This function first simulates a two-arm time-to-event trial using
\code{\link{generate_data}} and constructs interim datasets
(\code{data.enroll} and \code{data.eventcensor}). It then fits the enrollment,
event-time, and random censoring models and generates posterior predictive draws
of the calendar time at which the cumulative number of
events reaches \code{E_target} using \code{\link{predict_eventtime}}.

Only simulated datasets in which the target number of events \code{E_target}
is reachable are retained for analysis. Up to \code{nsim.max} datasets are
generated in order to obtain at most \code{nsim} valid replicates. As a result,
the retained replicates correspond to a subset of the attempted simulations,
and their associated seeds are recorded explicitly in the returned object.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
## Using nsim = 2, chains = 2, and iter = 2000 to reduce runtime.
## Use larger nsim, chains and iter in real analyses.
oc <- get_oc(
  N = 200, E_target = 150,
  E_cutoff = 75, p_trt = 0.5,
  cov_type = c("binary", "continuous"),
  cov_dist = c(0.5, 2),
  beta.event = c(-0.2, -0.2),
  beta.censor = c(0, 0),
  logHR.trt = log(0.65),
  enroll_rate = 16,
  dist.event = "Weibull", dist.censor = "Weibull",
  event.scale = 1/5^3, event.shape = 3,
  censor.scale = 1/10^6, censor.shape = 6,
  blinded = TRUE,
  assess_window = 2,
  seed = 1,
  chains = 2, iter = 2000,
  nsim = 2,
  n_workers = 1
)

summary(oc)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET operating characteristics: 
\code{\link{summary.BayesPET_oc}()}
}
\concept{BayesPET operating characteristics}
