% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesPET.R
\name{fit_event_blind}
\alias{fit_event_blind}
\title{Fit a Weibull event-time model with unknown treatment assignments}
\usage{
fit_event_blind(
  t_event,
  status_event,
  p_trt,
  cov = NULL,
  hyperparams_event = list(),
  chains = 4,
  iter = 4000,
  seed = 123,
  refresh = 0,
  warmup = floor(iter/2),
  mc.cores = 1,
  control = list(adapt_delta = 0.95),
  return_fit = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{t_event}{Numeric observed time to event \eqn{t^*_{ei}}. Must be \code{>0}.}

\item{status_event}{Integer vector of event indicators \eqn{\delta_{ei}} with values \code{0} or \code{1}
(\code{1} = event observed, \code{0} = right-censored at \code{t_event}).}

\item{p_trt}{Scalar randomization probability to the experimental arm, \eqn{\gamma \in (0,1)}.}

\item{cov}{Optional matrix or data frame of covariates \eqn{\boldsymbol{Z}}.
Each row corresponds to a subject and each column to a covariate.
Covariates must be numeric and are treated as linear effects in the model.
Only binary (0/1) and continuous covariates are supported.
Multilevel or categorical variables are not expanded into dummy variables;
if provided as numeric (e.g., factor codes), they are treated as continuous.
If \code{NULL} (default), a no-covariate Weibull model is fitted.}

\item{hyperparams_event}{A named list of prior hyperparameters for the event-time model.
If it is empty (\code{list()}), default values
are assigned internally.
\itemize{
\item \code{alpha_e}, \code{beta_e}: Shape and rate parameters of the Gamma prior for
the baseline scale parameter \eqn{\lambda_{0e}}
(defaults: \eqn{0.1}, \eqn{0.1}).
\item \code{alpha_re}, \code{beta_re}: Shape and rate parameters of the Gamma prior for
the baseline shape parameter \eqn{\rho_e}
(defaults: \eqn{0.1}, \eqn{0.1}).
\item \code{mu_eta}, \code{sigma_eta}: Mean and standard deviation of the Normal prior,
truncated to \eqn{[0, \infty)},
for the treatment effect (log hazard ratio) \eqn{\eta} (defaults: \eqn{0}, \eqn{\sqrt{2}}).
\item \code{mu_be}, \code{sigma_be}: Mean and standard deviation of the Normal
prior for the covariate effects \eqn{\beta_{ej}}
(defaults: \eqn{0}, \eqn{\sqrt{10}}).
}
No other hyperparameters are allowed.}

\item{chains}{Number of Markov chain Monte Carlo (MCMC) chains. Defaults to \code{4}.}

\item{iter}{Number of iterations per chain (including warmup). Defaults to \code{4000}.}

\item{seed}{Optional integer seed passed to \code{\link[rstan]{sampling}} for reproducibility. If \code{NULL},
'Stan' generates a seed internally and results may differ across runs.
Defaults to \code{123}.}

\item{refresh}{Frequency of progress updates from \code{\link[rstan]{sampling}}. Set to \code{0} (default) to suppress output.}

\item{warmup}{Number of warmup (burn-in) iterations per chain. Must be strictly smaller
than \code{iter}. Defaults to \code{floor(iter / 2)}.}

\item{mc.cores}{Integer. Number of CPU cores to use when executing Markov
chains in parallel via \code{\link[rstan]{sampling}}. Defaults to \code{1}.
We recommend setting \code{mc.cores} to the maximum number of processors
supported by the available hardware and memory, up to the number of
chains.}

\item{control}{A named list of sampler control parameters passed to
\code{\link[rstan]{sampling}}. Examples include \code{adapt_delta} and
\code{max_treedepth}.
Defaults to \code{list(adapt_delta = 0.95)}.}

\item{return_fit}{Logical; if \code{TRUE}, also return the underlying 'rstan' \code{stanfit} object.
Defaults to \code{FALSE}.}

\item{quiet}{Logical. If \code{TRUE} (default), suppress messages and diagnostic warnings
from 'Stan' during model fitting. Useful for large simulation studies.}
}
\value{
A list with the following components:
\itemize{
\item \code{eta}: Posterior draws of the treatment log hazard ratio \eqn{\eta}.
\item \code{rho_e}: Posterior draws of the Weibull shape parameter \eqn{\rho_e}.
\item \code{lambda_0e}: Posterior draws of the baseline Weibull scale parameter \eqn{\lambda_{0e}}.
\item \code{beta_e}: Posterior draws of the covariate log hazard ratios \eqn{\boldsymbol{\beta}_e}, or \code{NULL}
if no covariates are included.
\item \code{x}: Posterior draws of latent treatment indicators \eqn{x_i}.
\item \code{fit}: The 'rstan' \code{stanfit} object (only if \code{return_fit = TRUE}).
}
}
\description{
Fits a Weibull event-time model formulated as a mixture over unobserved
treatment assignments. The function returns posterior draws of the
Weibull shape parameter \eqn{\rho_e}, the baseline scale parameter
\eqn{\lambda_{0e}}, the treatment log hazard ratio \eqn{\eta},
and when covariates are included, the covariate log hazard ratios
\eqn{\boldsymbol{\beta}_e}.
Posterior draws of the latent treatment indicators \eqn{x_i} are also returned.
}
\details{
Let \eqn{T_{ei}} denote the event time for subject \eqn{i}. Let
\eqn{\boldsymbol{Z}_i} denote the corresponding covariate vector, which is the
\eqn{i} th row of \code{cov} when provided. Treatment assignment is represented
by a latent indicator \eqn{x_i}, where
\eqn{x_i = 0} denotes control and \eqn{x_i = 1} denotes experimental treatment.
The latent treatment indicators are jointly inferred with the model parameters
from the observed event time data.

The treatment effect parameter \eqn{\eta} represents the log hazard ratio
comparing experimental treatment to control, and
\eqn{\boldsymbol{\beta}_e} denotes the vector of covariate regression
coefficients (log hazard ratios) in the proportional hazards model.

The baseline event time distribution follows a Weibull model with density
\deqn{
  f_{0e}(t) = \lambda_{0e}\,\rho_e\, t^{\rho_e - 1}
  \exp(-\lambda_{0e} t^{\rho_e}), \quad t \ge 0.
}

Conditional on treatment and covariates, the hazard function is
\deqn{
  h_e(t \mid x_i, \boldsymbol{Z}_i)
  = \lambda_{0e}\,\rho_e\, t^{\rho_e - 1}
  \exp(\eta x_i + \boldsymbol{Z}_i^\top \boldsymbol{\beta}_e), \quad t \ge 0,
}
and the corresponding survival function is
\deqn{
  S_e(t \mid x_i, \boldsymbol{Z}_i)
  = \exp\{-\lambda_{0e}\, t^{\rho_e}
    \exp(\eta x_i + \boldsymbol{Z}_i^\top \boldsymbol{\beta}_e)\}, \quad t \ge 0.
}

For reference, 'Stan' uses an equivalent Weibull representation based on a shape
parameter \eqn{\rho_e} and a scale parameter \eqn{\sigma}, with baseline density
\deqn{
  f_{0e}(t) = (\rho_e / \sigma)\, (t / \sigma)^{\rho_e - 1}
  \exp\{-(t / \sigma)^{\rho_e}\}, \quad t \ge 0.
}
The two formulations are related through
\deqn{
  \sigma_i =
  \{\lambda_{0e}\exp(\eta x_i + \boldsymbol{Z}_i^\top \boldsymbol{\beta}_e)\}^{-1/\rho_e}.
}
Because \eqn{x_i} is not observed in blinded randomized trials, it is
treated as a latent variable, and the observed event-time data
marginally follow a mixture of two Weibull distributions corresponding
to the latent treatment groups.

To avoid label switching in posterior inference, the treatment effect
parameter \eqn{\eta} is assigned a Normal prior truncated to
\eqn{[0, \infty)}, restricting \eqn{\eta} to be nonnegative.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(data_example)
example_eventcensor<-data_example$example_eventcensor
# Use 2 chains and iter = 1000 here to reduce runtime for the example;
# use more chains in real analyses.
fit_e_blind <- fit_event_blind(
  t_event = example_eventcensor$time,
  status_event = example_eventcensor$eventstatus,
  cov = example_eventcensor[,6:7],
  p_trt = 0.5,
  chains = 2,
  iter = 1000, seed = 123,
  return_fit = TRUE
)

summary(fit_e_blind$eta)
print(fit_e_blind$fit)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET model fitting: \code{\link{fit_censor}}, \code{\link{fit_enroll}},
\code{\link{fit_event_unblind}},
\code{\link{fit_models}}, \cr \code{\link{print.BayesPET_fit}}
}
