% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructAdjacency.R
\name{.adjBeta}
\alias{.adjBeta}
\title{Construct Adjacency Matrix for Parent-Child Relationships Using Beta Method
This function constructs an adjacency matrix for parent-child relationships
using a method in beta testing. It identifies parent-child pairs based on the
specified component of relatedness.}
\usage{
.adjBeta(
  ped,
  component,
  adjBeta_method = 5,
  parList = NULL,
  lastComputed = 0,
  lens = NULL,
  saveable = FALSE,
  resume = FALSE,
  save_path = NULL,
  verbose = FALSE,
  save_rate_parlist = NULL,
  update_rate = NULL,
  checkpoint_files = NULL,
  config,
  compress = config$compress,
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{component}{character.  Which component of the pedigree to return.  See Details.}

\item{adjBeta_method}{numeric The method to use for computing the building the adjacency_method matrix when using the "beta" build}

\item{parList}{a list of parent-child relationships}

\item{lastComputed}{the last computed index}

\item{lens}{a vector of the lengths of the parent-child relationships}

\item{saveable}{logical. If TRUE, save the intermediate results to disk}

\item{resume}{logical. If TRUE, resume from a checkpoint}

\item{save_path}{character. The path to save the checkpoint files}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{save_rate_parlist}{numeric. The rate at which to save the intermediate results by parent list. If NULL, defaults to save_rate*1000}

\item{update_rate}{numeric. The rate at which to print progress}

\item{checkpoint_files}{a list of checkpoint files}

\item{config}{a configuration list that passes parameters to the function}

\item{compress}{logical. If TRUE, use compression when saving the checkpoint files.  Defaults to TRUE.}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Construct Adjacency Matrix for Parent-Child Relationships Using Beta Method
This function constructs an adjacency matrix for parent-child relationships
using a method in beta testing. It identifies parent-child pairs based on the
specified component of relatedness.
}
