#' Example Dataset for bacteria_for_correlation
#'
#' A small synthetic dataset included with *AssumpSure* for demonstrating 
#' correlation analysis of the compositional data in the Correlation tab.
#'
#' The file is stored in `inst/extdata/bacteria_for_correlation.csv`.
#'
#' All values are synthetic, created only for demonstration; no human data were used,
#' and no ethical approval or consent is required.
#'
#' @format A CSV file with 126 rows and 21 columns:
#' \describe{
#'   \item{sample_id}{Sample identifier.}
#'   \item{B_longum}{Relative abundance of *Bifidobacterium longum*.}
#'   \item{E_coli}{Relative abundance of *Escherichia coli*.}
#'   \item{B_bifidum}{Relative abundance of *Bifidobacterium bifidum*.}
#'   \item{B_breve}{Relative abundance of *Bifidobacterium breve*.}
#'   \item{k_pneumoniae}{Relative abundance of *Klebsiella pneumoniae*.}
#'   \item{S_salivarius}{Relative abundance of *Streptococcus salivarius*.}
#'   \item{S_lactarius}{Relative abundance of *Streptococcus lactarius*.}
#'   \item{E_faecium}{Relative abundance of *Enterococcus faecium*.}
#'   \item{S_mitis}{Relative abundance of *Streptococcus mitis*.}
#'   \item{S_peroris}{Relative abundance of *Streptococcus peroris*.}
#'   \item{S_pneumoniae}{Relative abundance of *Streptococcus pneumoniae*.}
#'   \item{S_lutetiensis}{Relative abundance of *Streptococcus lutetiensis*.}
#'   \item{k_variicola}{Relative abundance of *Klebsiella variicola*.}
#'   \item{B_fragilis}{Relative abundance of *Bacteroides fragilis*.}
#'   \item{S_equinus}{Relative abundance of *Streptococcus equinus*.}
#'   \item{C_sp}{Relative abundance of *Clostridium* species.}
#'   \item{P_cumminsii}{Relative abundance of *Peptoniphilus cumminsii*.}
#'   \item{T_bernardiae}{Relative abundance of *Trueperella bernardiae*.}
#'   \item{C_simulans}{Relative abundance of *Corynebacterium simulans*.}
#'   \item{G_SGB61413}{Relative abundance of *Granulicatella* sp. SGB61413.}
#' }
#'
#' @source Simulated data generated by the author.
#'
#' @examples
#' read.csv(system.file("extdata", "bacteria_for_correlation.csv", package = "AssumpSure"))
#' @name bacteria_for_correlation
NULL
