% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\alias{metrics.data.frame}
\title{General Function to Estimate Performance}
\usage{
metrics(data, ...)

\method{metrics}{data.frame}(data, truth, estimate, ..., na_rm = TRUE, options = list())
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth},
\code{estimate}, and \code{...}.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected,
and it should correspond to the value of \code{event_level}. Otherwise, there
should be as many columns as factor levels of \code{truth} and the ordering of
the columns should be the same as the factor levels of \code{truth}.}

\item{truth}{The column identifier for the true results (that
is \code{numeric} or \code{factor}). This should be an unquoted column name
although this argument is passed by expression and support
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names).}

\item{estimate}{The column identifier for the predicted results
(that is also \code{numeric} or \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{options}{\verb{[deprecated]}

No longer supported as of yardstick 1.0.0. If you pass something here it
will be ignored with a warning.

Previously, these were options passed on to \code{pROC::roc()}. If you need
support for this, use the pROC package directly.}
}
\value{
A three column tibble.
\itemize{
\item When \code{truth} is a factor, there are rows for \code{\link[=accuracy]{accuracy()}} and the
Kappa statistic (\code{\link[=kap]{kap()}}).
\item When \code{truth} has two levels and 1 column of class probabilities is
passed to \code{...}, there are rows for the two class versions of
\code{\link[=mn_log_loss]{mn_log_loss()}} and \code{\link[=roc_auc]{roc_auc()}}.
\item When \code{truth} has more than two levels and a full set of class probabilities
are passed to \code{...}, there are rows for the multiclass version of
\code{\link[=mn_log_loss]{mn_log_loss()}} and the Hand Till generalization of \code{\link[=roc_auc]{roc_auc()}}.
\item When \code{truth} is numeric, there are rows for \code{\link[=rmse]{rmse()}}, \code{\link[=rsq]{rsq()}},
and \code{\link[=mae]{mae()}}.
}
}
\description{
This function estimates one or more common performance
estimates depending on the class of \code{truth} (see \strong{Value}
below) and returns them in a three column tibble.
}
\examples{

# Accuracy and kappa
metrics(two_class_example, truth, predicted)

# Add on multinomal log loss and ROC AUC by specifying class prob columns
metrics(two_class_example, truth, predicted, Class1)

# Regression metrics
metrics(solubility_test, truth = solubility, estimate = prediction)

# Multiclass metrics work, but you cannot specify any averaging
# for roc_auc() besides the default, hand_till. Use the specific function
# if you need more customization
library(dplyr)

hpc_cv \%>\%
  group_by(Resample) \%>\%
  metrics(obs, pred, VF:L) \%>\%
  print(n = 40)

}
\seealso{
\code{\link[=metric_set]{metric_set()}}
}
