% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-accuracy.R
\name{accuracy}
\alias{accuracy}
\alias{accuracy.data.frame}
\alias{accuracy_vec}
\title{Accuracy}
\usage{
accuracy(data, ...)

\method{accuracy}{data.frame}(data, truth, estimate, na_rm = TRUE, case_weights = NULL, ...)

accuracy_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the columns specified by the
\code{truth} and \code{estimate} arguments, or a \code{table}/\code{matrix} where the true
class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{accuracy_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Accuracy is the proportion of the data that are predicted correctly.
}
\section{Multiclass}{


Accuracy extends naturally to multiclass scenarios. Because
of this, macro and micro averaging are not implemented.
}

\examples{
library(dplyr)
data("two_class_example")
data("hpc_cv")

# Two class
accuracy(two_class_example, truth, predicted)

# Multiclass
# accuracy() has a natural multiclass extension
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  accuracy(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  accuracy(obs, pred)
}
\seealso{
Other class metrics: 
\code{\link{bal_accuracy}()},
\code{\link{detection_prevalence}()},
\code{\link{f_meas}()},
\code{\link{j_index}()},
\code{\link{kap}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{sens}()},
\code{\link{spec}()}
}
\author{
Max Kuhn
}
\concept{class metrics}
