% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_res.R
\name{io_res.character}
\alias{io_res.character}
\title{Import Documented Table as Resolved}
\usage{
\method{io_res}{character}(x, ext = getOption("yamlet_extension", ".yaml"), ...)
}
\arguments{
\item{x}{character file path; passed to \code{\link{io_csv.character}}}

\item{ext}{extension for metadata equivalent of x}

\item{...}{passed to \code{\link{io_csv.character}}}
}
\value{
decorated
}
\description{
Imports a documented table and resolves ambiguous guide elements.
A wrapper for \code{\link{io_csv.character}} that also
reads associated yamlet metadata, if present, and applies it
as attributes. Invokes \code{\link{resolve}} to resolve
ambiguity of 'guide' attribute, if possible. A short-cut
for \code{resolve(io_csv(x))}.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- io_csv(file) \%>\% resolve
y <- io_res(file)
identical(x, y)
}
\seealso{
Other io: 
\code{\link{io_csv}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{enscript.default}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
