% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load.R
\name{closed_data}
\alias{closed_data}
\title{Use closed data in WORCS project}
\usage{
closed_data(
  data,
  filename = paste0(deparse(substitute(data)), ".csv"),
  codebook = paste0("codebook_", deparse(substitute(data)), ".Rmd"),
  value_labels = paste0("value_labels_", deparse(substitute(data)), ".yml"),
  worcs_directory = ".",
  synthetic = TRUE,
  save_expression = write.csv(x = data, file = filename, row.names = FALSE),
  load_expression = read.csv(file = filename, stringsAsFactors = TRUE),
  ...
)
}
\arguments{
\item{data}{A data.frame to save.}

\item{filename}{Character, naming the file data should be written to. By
default, constructs a filename from the name of the object passed to
\code{data}.}

\item{codebook}{Character, naming the file the codebook should be written to.
An 'R Markdown' codebook will be created and rendered to
\code{\link[rmarkdown]{github_document}} ('markdown' for 'GitHub').
By default, constructs a filename from the name of the object passed to
\code{data}, adding the word 'codebook'.
Set this argument to \code{NULL} to avoid creating a codebook.}

\item{value_labels}{Character, naming the file the value labels of factors
and ordinal variables should be written to.
By default, constructs a filename from the name of the object passed to
\code{data}, adding the word 'value_labels'.
Set this argument to \code{NULL} to avoid creating a file with value labels.}

\item{worcs_directory}{Character, indicating the WORCS project directory to
which to save data. The default value \code{"."} points to the current
directory.}

\item{synthetic}{Logical, indicating whether or not to create a synthetic
dataset using the \code{\link{synthetic}} function. Additional arguments for
the call to \code{\link{synthetic}} can be passed through \code{...}.}

\item{save_expression}{An R-expression used to save the \code{data}.
Defaults to \code{write.csv(x = data, file = filename, row.names = FALSE)},
which writes a comma-separated, spreadsheet-style file.
The arguments \code{data} and \code{filename} are passed from
\code{open_data()} to the expression defined in \code{save_expression}.}

\item{load_expression}{An R-expression used to load the \code{data} from the
file created by \code{save_expression}. Defaults to
\code{read.csv(file = filename, stringsAsFactors = TRUE)}. This expression
is stored in the project's \code{.worcs} file, and invoked by
\code{load_data()}.}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
Returns \code{NULL} invisibly. This
function is called for its side effects.
}
\description{
This function saves a data.frame as a \code{.csv} file (using
\code{\link[utils:write.table]{write.csv}}), stores a checksum in '.worcs',
appends the \code{.gitignore} file to exclude \code{filename}, and saves a
synthetic copy of \code{data} for public use. To generate these synthetic
data, the function \code{\link{synthetic}} is used.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
  withr::with_tempdir({
    file.create(".worcs")
    df <- iris[1:3, ]
    df$Species <- droplevels(df$Species)
    closed_data(df, codebook = NULL)
  })
}
}
\seealso{
open_data closed_data save_data
}
