% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_contour}
\alias{wbt_lidar_contour}
\title{Lidar contour}
\usage{
wbt_lidar_contour(
  input,
  output = NULL,
  interval = 10,
  base = 0,
  smooth = 5,
  parameter = "elevation",
  returns = "all",
  exclude_cls = NULL,
  minz = NULL,
  maxz = NULL,
  max_triangle_edge_length = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR points.}

\item{output}{Name of the output vector lines file.}

\item{interval}{Contour interval.}

\item{base}{Base contour.}

\item{smooth}{Smoothing filter size (in num. points), e.g. 3, 5, 7, 9, 11.}

\item{parameter}{Interpolation parameter; options are 'elevation' (default), 'intensity', 'user_data'.}

\item{returns}{Point return types to include; options are 'all' (default), 'last', 'first'.}

\item{exclude_cls}{Optional exclude classes from interpolation; Valid class values range from 0 to 18, based on LAS specifications. Example, --exclude_cls='3,4,5,6,7,18'.}

\item{minz}{Optional minimum elevation for inclusion in interpolation.}

\item{maxz}{Optional maximum elevation for inclusion in interpolation.}

\item{max_triangle_edge_length}{Optional maximum triangle edge length; triangles larger than this size will not be gridded.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates a vector contour coverage from an input LiDAR point file.
}
\keyword{LiDARTools}
