% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubtrans_ch_nearby.R
\name{get_stops}
\alias{get_stops}
\title{Extract walking times to nearby public transportation stops}
\usage{
get_stops(pubtrans_ch_nearby)
}
\arguments{
\item{pubtrans_ch_nearby}{a response object from a \link[walkalytics]{pubtrans_ch_nearby} call to the \code{walkalytics} pubtrans API.}
}
\value{
A \code{data.frame} (\code{tibble::tibble}) that contains:
\itemize{
\item \code{name} name of the public tansportation stop (station).
\item \code{walktime} estimated walking time from the starting point to the station in  minutes.
\item \code{station_category} category of the station, ranging from high to low service frequency (1 to 5; unassigned >= 90).
\item \code{latitude} latitude of the station.
\item \code{longitude} longitude of the station.
\item \code{coordinates_type} type of geodetic system.
\item \code{transport_category} type of station.
\item \code{id} official ID of the station.
}
}
\description{
\code{get_stops} processses a response object from a \link[walkalytics]{pubtrans_ch_nearby} call to the \code{walkalytics} pubtrans API.
   Returns the nearby public tansportation stops, ordered by walking time.
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
    With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
pubtrans_ch_nearby(x = 8.05, y = 47.3, key = "abcd1234") \%>\% get_stops()
}

}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
