% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate_PAT.R
\name{authenticate_PAT}
\alias{authenticate_PAT}
\title{Authenticate to Tableau Server or Tableau Cloud}
\usage{
authenticate_PAT(
  pat_name,
  pat_secret,
  content_url,
  base_url,
  api_version = 3.4
)
}
\arguments{
\item{pat_name}{The name of the personal access token (PAT).}

\item{pat_secret}{The secret of the personal access token (PAT).}

\item{content_url}{The URL of the content to authenticate. For Tableau Server, this is typically the URL of the Tableau server followed by the site ID. For Tableau Cloud, this is usually the URL of the Tableau cloud workbook.}

\item{base_url}{The base URL of the Tableau server or Tableau cloud. For Tableau Server, this is usually the URL of the Tableau server. For Tableau Cloud, this is usually the URL of the Tableau cloud, and it must contain the pod name, such as 10az, 10ay, or us-east-1. For example, the base URL to sign in to a site in the 10ay pod would be: https://10ay.online.tableau.com.}

\item{api_version}{the api version to use. Default is 3.4}
}
\value{
A list containing the base URL, the access token, the site ID, and the user ID.
}
\description{
This function authenticates to a Tableau Server or Tableau Cloud using a personal access token (PAT).
}
