% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate_server.R
\name{authenticate_server}
\alias{authenticate_server}
\title{Authenticate on the Tableau server.}
\usage{
authenticate_server(username, password, base_url, api_version = 3.4)
}
\arguments{
\item{username}{The username on the Tableau server.}

\item{password}{The password on the Tableau server.}

\item{base_url}{The base URL of the Tableau server.}

\item{api_version}{The API version to use (default: 3.4).}
}
\value{
A list containing the authentication variables: base_url, token, site_id, and user_id.
}
\description{
Authenticates the user on the Tableau server and retrieves the necessary authentication variables for running other Tableau REST API methods.
}
\seealso{
Other Tableau REST API: 
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()}
}
\concept{Tableau REST API}
