% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_datatable.R
\name{prep_table}
\alias{prep_table}
\title{Prepare a data table for displaying}
\usage{
prep_table(
  y,
  df,
  df_summarized,
  id,
  y_right = NULL,
  facet_var = rlang::sym("VIS_Groep"),
  facet_name_var = rlang::sym("VIS_Groep_naam"),
  table_type = c("basic", "advanced"),
  rownames = FALSE,
  extensions = c("Buttons"),
  options_DT = basic_options(),
  limit_width = "values",
  ...
)
}
\arguments{
\item{y}{A string specifying the column name to be used as the y-axis variable.}

\item{df}{A data frame containing the raw data.}

\item{df_summarized}{A data frame containing the summarized data.}

\item{id}{A string specifying the ID associated with the data.}

\item{y_right}{An optional string specifying the column name to be used as the second y-axis variable. Default is NULL.}

\item{facet_var}{A symbol specifying the column to be used for faceting. Default is 'VIS_Groep'.}

\item{facet_name_var}{A symbol specifying the column to be used for faceting names. Default is 'VIS_Groep_naam'.}

\item{table_type}{Choose from basic for a simple datatable and advanced for more buttons etc.}

\item{rownames}{A logical value indicating whether to display row names.}

\item{extensions}{A character vector specifying the DataTables extensions to be used.}

\item{options_DT}{A list of DataTables options.}

\item{limit_width}{A character string indicating how to limit column width.}

\item{...}{Further arguments passed on to the 'make_basic_table' function.}
}
\value{
A DT::datatable object ready for displaying.
}
\description{
This function prepares a data table for displaying by providing user-friendly names, removing unneeded variables, and formatting percentages.
}
\examples{
df <- data.frame(VIS_Groep = c("Group1", "Group1", "Group2", "Group2"),
                VIS_Groep_naam = c("Name1", "Name1", "Name2", "Name2"),
                y = c(TRUE, TRUE, FALSE, FALSE), z = c(TRUE, FALSE, TRUE, FALSE))
df_summarized <- df \%>\%
 dplyr::group_by(VIS_Groep, VIS_Groep_naam) \%>\%
 dplyr::summarise(
   y = mean(y),
   z = mean(z)
 ) \%>\%
 dplyr::ungroup()
 id <- "id"
output <- prep_table("y", df, df_summarized, id = id)

}
