% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_items}
\alias{effect_metrics_items}
\title{Test whether a distribution is normal for each item}
\usage{
effect_metrics_items(data, cols, labels = TRUE, clean = TRUE, ...)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{The column holding metric values.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker table containing itemwise statistics:
\itemize{
\item \strong{skewness}: Measure of asymmetry in the distribution. A value of 0 indicates perfect symmetry.
\item \strong{kurtosis}: Measure of the "tailedness" of the distribution.
\item \strong{W}: W-statistic from the Shapiro-Wilk normality test.
\item \strong{p}: p-value for the statistical test.
\item \strong{stars}: Significance stars based on p-value (*, **, ***).
\item \strong{normality}: Interpretation of normality based on Shapiro-Wilk test.
}
}
\description{
The test is calculated using \code{stats::\link[stats:shapiro.test]{shapiro.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_items(data, starts_with("cg_adoption"))


}
\keyword{internal}
