% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_graphics.R
\name{vascr_plot_line}
\alias{vascr_plot_line}
\title{Plot a line graph with vascr}
\usage{
vascr_plot_line(
  data.df,
  errorbars = Inf,
  alpha = 0.3,
  text_labels = TRUE,
  facet_expt = TRUE,
  show_linetypes = TRUE,
  explanatory = FALSE
)
}
\arguments{
\item{data.df}{The vascr data set to plot}

\item{errorbars}{Type of error bars, Inf for ribbons, 0 for no errors and any integer to plot every nth line}

\item{alpha}{Transparency of the error ribbon plotted}

\item{text_labels}{Show or hide well labels}

\item{facet_expt}{Facet out different experiments, defaults to TRUE}

\item{show_linetypes}{Include the line type for each experiment in the key. Default TRUE}

\item{explanatory}{Whether to include commentary about unit meaning on y axis (default TRUE)}
}
\value{
a ggplot containing the data
}
\description{
Plot a line graph with vascr
}
\examples{
vascr_plot_line(data.df = growth.df \%>\% vascr_subset(unit = "Rb"))
vascr_plot_line(growth.df \%>\% vascr_subset(unit = "Rb") \%>\% vascr_summarise(level = "experiments"))
data.df = growth.df \%>\% vascr_subset(unit = "Rb") \%>\% vascr_summarise(level = "summary")
vascr_plot_line(data.df, text_labels = FALSE)

growth.df \%>\% vascr_subset(unit = "R", frequency = 4000)  \%>\%
vascr_plot_line(facet = FALSE)

growth.df \%>\% vascr_subset(unit = "R", frequency = 4000)  \%>\%
vascr_plot_line(explanatory = TRUE)

}
