% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_genomecov.R
\name{bed_genomecov}
\alias{bed_genomecov}
\title{Calculate coverage across a genome}
\usage{
bed_genomecov(x, genome, zero_depth = FALSE)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{genome}{\link{genome_df}}

\item{zero_depth}{If TRUE, report intervals with zero depth. Zero depth intervals will
be reported with respect to groups.}
}
\value{
\link{ivl_df} with the an additional column:
\itemize{
\item \code{.depth} depth of interval coverage
}
}
\description{
This function is useful for calculating interval coverage across an entire genome.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end, ~strand,
  "chr1", 20, 70, "+",
  "chr1", 50, 100, "-",
  "chr1", 200, 250, "+",
  "chr1", 220, 250, "+"
)

genome <- tibble::tribble(
  ~chrom, ~size,
  "chr1", 500,
  "chr2", 1000
)

bed_genomecov(x, genome)

bed_genomecov(dplyr::group_by(x, strand), genome)

bed_genomecov(dplyr::group_by(x, strand), genome, zero_depth = TRUE)

}
\seealso{
\url{https://bedtools.readthedocs.io/en/latest/content/tools/genomecov.html}

Other single set operations: 
\code{\link{bed_cluster}()},
\code{\link{bed_complement}()},
\code{\link{bed_flank}()},
\code{\link{bed_merge}()},
\code{\link{bed_partition}()},
\code{\link{bed_shift}()},
\code{\link{bed_slop}()}
}
\concept{single set operations}
