% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.axpyi.R
\name{tropicalsparse.axpyi}
\alias{tropicalsparse.axpyi}
\title{tropicalsparse.axpyi()}
\usage{
tropicalsparse.axpyi(y, alpha, x, algebraType)
}
\arguments{
\item{y}{is a vector.}

\item{alpha}{is a constant.}

\item{x}{is a vector.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Returns a vector.
}
\description{
\code{tropicalsparse.axpyi} function multiplies the vector \code{x} by the constant \code{alpha}
and adds the result to the vector \code{y}.
}
\details{
The input of the function \code{tropicalsparse.axpyi} is two vectors, a constant and type of Tropical
Algebra. \code{algebraType} is used to specify type of Tropical Algebra. This can be \code{minplus} or
\code{maxplus}. For more details about \code{algebraType}, see \code{detail} section of
\code{\link{check.infinityM}} or \code{\link{check.infinityV}}. All inputs of this method are compulsory. The
operation is expressed as: y = y + alpha * x where \code{x} and \code{y} must be a vector while \code{alpha}
must be a constant.
}
\examples{
a <- c(2, Inf, 5, 0, Inf, Inf, Inf, 10, Inf)
b <- c(0, 5, Inf, Inf, 12, 2, Inf, Inf, 3)
alpha <- 5

tropicalsparse.axpyi(a, alpha, b, 'minplus')

# [1]   2  10   5   0  17   7 Inf  10   8

}
\seealso{
\code{\link{tropicalsparse.doti}}
}
