% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsboost.R
\name{lsboost}
\alias{lsboost}
\alias{print.lsboost}
\alias{predict.lsboost}
\title{Gradient tree boosting with least squares (LS) loss}
\usage{
lsboost(
  X,
  y,
  ntree = 100,
  shrinkage = 0.1,
  depth = 6,
  subsample = 0.5,
  init = mean(y)
)

\method{print}{lsboost}(x, ...)

\method{predict}{lsboost}(object, newdata, ntree = NULL, individual = FALSE, ...)
}
\arguments{
\item{X}{A data frame of only predictors.}

\item{y}{A vector of response values}

\item{ntree}{Integer specifying the number of trees in the ensemble to use.
Defaults to using all the trees in the ensemble.}

\item{shrinkage}{Numeric specifying the shrinkage factor.}

\item{depth}{Integer specifying the depth of each tree.}

\item{subsample}{Numeric specifying the proportion of the training data to
randomly sample before building each tree. Default is \code{0.5}.}

\item{init}{Numeric specifying the initial value to boost from. Defaults to
the mean response (i.e., \code{mean(y)}).}

\item{x}{An object of class \code{"lsboost"}.}

\item{...}{Additional optional arguments. (Currently ignored.)}

\item{object}{An object of class \code{"lsboost"}.}

\item{newdata}{Data frame of new observations for making predictions.}

\item{individual}{Logical indicating whether or not to return the (shrunken)
predictions from each tree individually (\code{TRUE}) or the overall ensemble
prediction (\code{FALSE}). Default is \code{FALSE}.}
}
\value{
An object of class \code{"lsboost"} which is just a list with the 
following components:
\itemize{
  \item \code{trees} A list of length \code{ntree} containing the individual 
  \code{\link[rpart]{rpart}} tree fits.
  \item \code{shrinkage} The corresponding shrinkage parameter.
  \item \code{depth} The maximum depth of each tree.
  \item \code{subsample} The (row) subsampling rate.
  \item \code{init} The initial constant fit.
}

A vector (\code{individual = TRUE}) or matrix 
(\code{individual = FALSE}) of predictions.
}
\description{
A poor-man's implementation of stochastic gradient tree boosting with LS 
loss.

Print basic information about a fitted \code{"lsboost"} object.

Compute predictions from an \code{"lsboost"} object using new data.
}
\note{
By design, the final model does not include the predictions from the initial
(constant) fit. So the constant is stored in the \code{init} component of the
returned output to be used later by \code{predict.lsboost()}.
}
\examples{
# Simulate data from the Friedman 1 benchmark problem
set.seed(1025)  # for reproducibility
trn <- gen_friedman1(500)  # training data
tst <- gen_friedman1(500)  # test data

# Gradient boosted decision trees
set.seed(1027)  # for reproducibility
bst <- lsboost(subset(trn, select = -y), y = trn$y, depth = 2)
pred <- predict(bst, newdata = tst)
mean((pred - tst$y) ^ 2)
}
