% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_boundary.R
\name{decision_boundary}
\alias{decision_boundary}
\alias{decision_boundary.default}
\title{Add decision boundary to a scatterplot.}
\usage{
decision_boundary(model, train, y, x1, x2, pfun, grid.resolution = 100, ...)

\method{decision_boundary}{default}(
  model,
  train,
  y,
  x1,
  x2,
  pfun = NULL,
  grid.resolution = 100,
  ...
)
}
\arguments{
\item{model}{The associated model object.}

\item{train}{Data frame of training observations.}

\item{y}{Character string giving the name of the outcome variable in 
\code{train}.}

\item{x1}{Character string giving the name of the predictor in \code{train} 
that corresponds to the x-axis.}

\item{x2}{Character string giving the name of the predictor in \code{train} 
that corresponds to the y-axis.}

\item{pfun}{Optional prediction wrapper that returns a vector of predicted
class labels. It must have exactly two arguments: \code{object} and
\code{newdata}.}

\item{grid.resolution}{Integer specifying the resolution of the contour plot.
Default is \code{100}.}

\item{...}{Additional optional arguments to be passed on to 
\code{\link[graphics]{contour}}.}
}
\value{
No return value, only called for side effects; in this case, a 
contour displaying the decision boundary of a classifier is added to an
existing scatterplot.
}
\description{
Adds the decision boundary from a classification model (binary or multiclass)
to an existing scatterplot.
}
\note{
Based on a function written by Michael Hahsler; see
https://michael.hahsler.net/SMU/EMIS7332/R/viz_classifier.html.
}
\examples{
\dontrun{
library(mlbench)
library(rpart)
library(treemisc)

# Generate training data from the twonorm benchmark problem
set.seed(1050)  # for reproducibility
trn <- as.data.frame(mlbench.twonorm(500, d = 2))

# Fit a default classification tree
tree <- rpart(classes ~ ., data = trn)

# Scatterplot of training data
palette("Okabe-Ito")
plot(x.2 ~ x.1, data = trn, col = as.integer(trn$classes) + 1,
     xlab = expression(x[1]), ylab = expression(x[2]))
palette("default")

# Add a decision boundary
decision_boundary(tree, train = trn, y = "y", x1 = "x.1", x2 = "x.2")
}
}
