% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBalanced.R
\name{makePhylo3DBalanced}
\alias{makePhylo3DBalanced}
\alias{rotate3dVec}
\title{Turn a rooted 3D tree into one of its balanced versions}
\usage{
makePhylo3DBalanced(tree)

rotate3dVec(angle, axis, vec)
}
\arguments{
\item{tree}{A rooted tree in phylo3D format (no special node enumeration 
required, except that nodes are numbered from 1 to |V| = the total number of
nodes). There must be at least 2 nodes, i.e., one edge. The attributes 
'node.coord' and 'edge.weight' are strictly required.}

\item{angle}{Angle for the rotation.}

\item{axis}{Rotation axis.}

\item{vec}{Numeric vector of size 3 (3D coordinates of the
vector that shall be rotated).}
}
\value{
\code{makePhylo3DBalanced} Tree in phylo3D format which is balanced
with regards to all four node imbalance measurements and their 
corresponding imbalance indices.

\code{rotate3dVec} Numeric vector of size 3 (3D coordinates of the
rotated vector).
}
\description{
\code{makePhylo3DBalanced} - Creates a balanced version of a rooted 3D tree
in phylo3D format. From the leaves of lowest depth to the root, each node
is turned into a balanced node by rotating its pending subtree such that
it is in line with its incoming edge. The edge and subtree lengths and 
weights as well as the angles between the outgoing edges of a single node 
(the sister edges) are left intact. \cr
Note that this function yields only one of many possible balanced 
version of the given rooted 3D tree (most often the minimal tree under the 
aforementioned requirements is not unique).

\code{rotate3dVec} - Rotates a vector in 3D space for a given angle and 
rotation axis.
}
\examples{
tree <- treeDbalance::extendPhylo(treeDbalance::example3Dtrees$bean22)
tree_bal <- makePhylo3DBalanced(tree)
rotate3dVec(angle = pi/2, axis = c(0,-1,0), vec = c(5,0,0)) # approx. (0,0,5)
round(rotate3dVec(angle = pi/2, axis = c(0,-1,0), vec = c(5,0,0)),15)
}
\author{
Sophie Kersting, Luise Kühn
}
