% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample_proper_car}
\alias{sample_proper_car}
\title{Gibbs sampler for a proper CAR latent Gaussian model}
\usage{
sample_proper_car(
  y,
  A,
  rho = 0.99,
  n_iter,
  burn = 0L,
  thin = 1L,
  a_tau = 1,
  b_tau = 1,
  a_kappa = 1,
  b_kappa = 1,
  init = NULL,
  symmetrize = FALSE,
  check = TRUE
)
}
\arguments{
\item{y}{Numeric vector of observations (length n).}

\item{A}{Adjacency matrix (dense or sparse). Diagonal ignored.}

\item{rho}{Proper CAR dependence parameter (must satisfy car_precision checks).}

\item{n_iter}{Integer number of iterations.}

\item{burn}{Integer burn-in iterations to drop (default 0).}

\item{thin}{Integer thinning interval (default 1).}

\item{a_tau, b_tau}{Gamma(shape, rate) prior for tau.}

\item{a_kappa, b_kappa}{Gamma(shape, rate) prior for kappa.}

\item{init}{Optional list with elements x, tau, kappa.}

\item{symmetrize}{Passed to car_precision().}

\item{check}{Passed to car_precision().}
}
\value{
List with x (matrix), tau, kappa, and settings.
}
\description{
Model:
\deqn{y \mid x, \tau \sim N(x, \tau^{-1} I)}
\deqn{x \mid \kappa \sim N(0, (\kappa Q)^{-1}), \quad Q = D - \rho A \text{ (proper CAR)}}
\deqn{\tau \sim \mathrm{Gamma}(a_{\tau}, b_{\tau}) \quad \text{(shape-rate)}}
\deqn{\kappa \sim \mathrm{Gamma}(a_{\kappa}, b_{\kappa}) \quad \text{(shape-rate)}}
}
