% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis_multi.R
\name{param_plot_multi}
\alias{param_plot_multi}
\title{Plot temporal para varios parametros (filtro por rio/ponto)}
\usage{
param_plot_multi(
  df,
  parametros,
  rios = NULL,
  pontos = NULL,
  add_trend = TRUE,
  facet = c("parametro", "none", "grid")
)
}
\arguments{
\item{df}{Data frame com \code{data} e colunas dos parametros.}

\item{parametros}{Vetor de nomes de parametros.}

\item{rios}{Vetor de rios para filtrar (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos para filtrar (opcional; usa coluna \code{ponto} se existir).}

\item{add_trend}{Logical; se TRUE, adiciona reta \code{lm} em cada painel.}

\item{facet}{"parametro", "none" ou "grid".}
}
\value{
Objeto \code{ggplot}.
}
\description{
Combina varios parametros em um unico grafico. Por padrao:
\itemize{
\item cor = \code{ponto} (se existir);
\item \code{facet = "parametro"} cria paineis por parametro;
\item \code{facet = "grid"} usa grade \code{ponto ~ parametro} quando ha mais de um ponto.
}
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_plot_multi(wq_demo, c("turbidez","od"), pontos = c("P1","P2"),
                 add_trend = TRUE, facet = "grid")
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot}()},
\code{\link{param_summary}()},
\code{\link{param_summary_multi}()},
\code{\link{param_trend}()},
\code{\link{param_trend_multi}()}
}
\concept{parameter-tools}
