% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_cache_indexing.R
\name{tw_check_cache_index}
\alias{tw_check_cache_index}
\title{Check if cache table is indexed}
\usage{
tw_check_cache_index(
  table_name = NULL,
  type = "item",
  show_details = FALSE,
  language = tidywikidatar::tw_get_language(),
  response_language = tidywikidatar::tw_get_language(),
  cache = NULL,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{table_name}{Name of the table in the database. If given, it takes
precedence over other parameters.}

\item{type}{Defaults to "item". Type of cache file to output. Values
typically used by \code{tidywikidatar} include "item", "search_item",
"search_property", and "qualifier".}

\item{show_details}{Logical, defaults to \code{FALSE}. If \code{FALSE}, return a
logical vector of length one (\code{TRUE} if the table was indexed, \code{FALSE} if
it was not). If \code{TRUE}, returns a data frame with more details about the
index.}

\item{language}{Language to be used for the search. Can be set once per
session with \code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full
list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{response_language}{Language to be used for the returned labels and
descriptions. Corresponds to the \code{uselang} parameter of the MediaWiki API,
as described
\href{https://www.wikidata.org/w/api.php?action=help&modules=wbsearchentities}{in
the official documentation}. Can be set once per session with
\code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{all
available language codes}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
If \code{show_details} is set to \code{FALSE}, return a logical vector of
length one (\code{TRUE} if the table was indexed, \code{FALSE} if it was not). If
\code{show_details} is set to \code{TRUE}, returns a data frame with more details
about the index.
}
\description{
Tested only with SQLite and MySql. May work with other drivers. Used to check
if given cache table is indexed (if created with any version of
\code{tidywikidatar} before 0.6, they are probably not indexed and less
efficient).
}
\examples{
if (interactive()) {
  tw_enable_cache()
  tw_set_cache_folder(path = fs::path(
    fs::path_home_r(),
    "R",
    "tw_data"
  ))

  tw_set_language(language = "en")

  tw_check_cache_index()
}
}
