% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_numeric}
\alias{column_numeric}
\title{Construct a Real-Valued Column}
\usage{
column_numeric(..., shape = c(1L), default_value = NULL,
  dtype = tf$float32, normalizer_fn = NULL)
}
\arguments{
\item{...}{Expression(s) identifying input feature(s). Used as the column
name and the dictionary key for feature parsing configs, feature tensors,
and feature columns.}

\item{shape}{An integer vector that specifies the shape of the tensor. An
integer can be given which means a single dimension tensor with given
width. The tensor representing the column will have the shape of
\code{batch_size + shape}.}

\item{default_value}{A single value compatible with \code{dtype} or an iterable of
values compatible with \code{dtype} which the column takes on during parsing if
data is missing. A default value of \code{NULL} will cause \code{tf$parse_example} to
fail if an example does not contain this column. If a single value is
provided, the same value will be applied as the default value for every
item. If an iterable of values is provided, the shape of the
\code{default_value} should be equal to the given \code{shape}.}

\item{dtype}{The types for values contained in the column. The default value
is \code{tf$float32}. Must be a non-quantized, real integer or floating point
type.}

\item{normalizer_fn}{If not \code{NULL}, a function that can be used to normalize
the value of the tensor after \code{default_value} is applied for parsing.
Normalizer function takes the input \code{Tensor} as its argument, and returns
the output tensor. (e.g. \code{function(x) {(x - 3.0) / 4.2)}}. Please note that
even though the most common use case of this function is normalization, it
can be used for any kind of Tensorflow transformations.}
}
\value{
A numeric column.
}
\description{
Construct a Real-Valued Column
}
\section{Raises}{

\itemize{
\item TypeError: if any dimension in shape is not an int
\item ValueError: if any dimension in shape is not a positive integer
\item TypeError: if \code{default_value} is an iterable but not compatible with \code{shape}
\item TypeError: if \code{default_value} is not compatible with \code{dtype}
\item ValueError: if \code{dtype} is not convertible to \code{tf$float32}
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_embedding}}, \code{\link{input_layer}}
}
\concept{feature column constructors}
