% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_and_evaluate.R
\name{train_and_evaluate.tf_estimator}
\alias{train_and_evaluate.tf_estimator}
\title{Train and evaluate the estimator.}
\usage{
\method{train_and_evaluate}{tf_estimator}(object, train_spec, eval_spec,
  ...)
}
\arguments{
\item{object}{An estimator object to train and evaluate.}

\item{train_spec}{A \code{TrainSpec} instance to specify the training specification.}

\item{eval_spec}{A \code{EvalSpec} instance to specify the evaluation and export specification.}

\item{...}{Not used.}
}
\description{
(Available since TensorFlow v1.4)
}
\details{
This utility function trains, evaluates, and (optionally) exports the model by
using the given \code{estimator}. All training related specification is held in
\code{train_spec}, including training \code{input_fn} and training max steps, etc. All
evaluation and export related specification is held in \code{eval_spec}, including
evaluation \code{input_fn}, steps, etc.

This utility function provides consistent behavior for both local
(non-distributed) and distributed configurations. Currently, the only
supported distributed training configuration is between-graph replication.

Overfitting: In order to avoid overfitting, it is recommended to set up the
training \code{input_fn} to shuffle the training data properly. It is also
recommended to train the model a little longer, say multiple epochs, before
performing evaluation, as the input pipeline starts from scratch for each
training. It is particularly important for local training and evaluation.

Stop condition: In order to support both distributed and non-distributed
configuration reliably, the only supported stop condition for model
training is \code{train_spec.max_steps}. If \code{train_spec.max_steps} is \code{NULL}, the
model is trained forever. \emph{Use with care} if model stop condition is
different. For example, assume that the model is expected to be trained with
one epoch of training data, and the training \code{input_fn} is configured to throw
\code{OutOfRangeError} after going through one epoch, which stops the
\code{Estimator.train}. For a three-training-worker distributed configuration, each
training worker is likely to go through the whole epoch independently. So, the
model will be trained with three epochs of training data instead of one epoch.
}
\section{Raises}{

\itemize{
\item ValueError: if environment variable \code{TF_CONFIG} is incorrectly set.
}
}

\seealso{
Other training methods: \code{\link{eval_spec}},
  \code{\link{train_spec}}
}
\concept{training methods}
