% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotauc.R
\name{plotauc}
\alias{plotauc}
\title{Plot AUC Comparison Between Conditions}
\usage{
plotauc(tab, expdf, genevec = NA, auc_ctrlname = "AUC_ctrl",
auc_stressname = "AUC_HS",
pvalkstestcolname = "adjFDR_p_dAUC_Diff_meanFx_HS_ctrl",
labelx = "AUC in Control", labely = "AUC in Stress", axismin_x = -10,
axismax_x = 100, axismin_y = -10, axismax_y = 100, maintitle = "",
subtitle = "", legendpos = "bottom", formatname = "pdf", outfold = tempdir(),
outfile = "AUCcompare_pval", plottype = "pval", plot = FALSE,
universename = "Universe", groupname = "Group", verbose = TRUE)
}
\arguments{
\item{tab}{A data frame containing the AUC values for control and stress
conditions, and other columns required for plotting (e.g., p-values or
group memberships, see allauc).}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{genevec}{A vector of gene names to highlight on the plot, applicable
when \code{plottype} is set to "pval". Default is \code{NA}.}

\item{auc_ctrlname}{The column name in \code{tab} for the AUC under control
conditions. Default is \code{"AUC_ctrl"}.}

\item{auc_stressname}{The column name in \code{tab} for the AUC under stress
conditions. Default is \code{"AUC_HS"}.}

\item{pvalkstestcolname}{The column name in \code{tab} for the adjusted FDR
p-values from the KS test. Default is
\code{"adjFDR_p_dAUC_Diff_meanFx_HS_ctrl"}.}

\item{labelx}{Label for the x-axis. Default is \code{"AUC in Control"}.}

\item{labely}{Label for the y-axis. Default is \code{"AUC in Stress"}.}

\item{axismin_x}{Minimum value for the x-axis. Default is \code{-10}.}

\item{axismax_x}{Maximum value for the x-axis. Default is \code{100}.}

\item{axismin_y}{Minimum value for the y-axis. Default is \code{-10}.}

\item{axismax_y}{Maximum value for the y-axis. Default is \code{100}.}

\item{maintitle}{Main title of the plot. Default is an empty string.}

\item{subtitle}{Subtitle of the plot. Default is an empty string.}

\item{legendpos}{Position of the legend. Default is \code{"bottom"}.}

\item{formatname}{Format of the saved plot (e.g., "pdf", "png"). Default is
\code{"pdf"}.}

\item{outfold}{Output folder where the plot will be saved. Default is
\code{tempdir()}.}

\item{outfile}{Name of the output file. Default is
\code{"AUCcompare_pval"}.}

\item{plottype}{Type of plot to generate. Can be \code{"pval"} for p-value
based plots or \code{"groups"} for group-based plots. Default is
\code{"pval"}.}

\item{plot}{A logical flag indicating whether to display the plot
interactively (\code{TRUE}) or save it to a file (\code{FALSE}). Default is
\code{FALSE}.}

\item{universename}{Column name in \code{tab} representing the universe
group in group-based plots. Default is \code{"Universe"}.}

\item{groupname}{Column name in \code{tab} representing specific groups in
group-based plots. Default is \code{"Group"}.}

\item{verbose}{A logical flag indicating whether to display detailed
messages about the function's progress. Default is \code{TRUE}.}
}
\value{
A plot comparing AUC values between control and stress conditions,
 either displayed or saved to a file.
}
\description{
This function generates scatterplots comparing the area under the curve (AUC)
for control and stress conditions, with an option to highlight specific genes
or groups. The plot can be saved as a file or displayed interactively.
}
\details{
The function supports two plot types:
\itemize{
  \item \code{"pval"}: The plot highlights genes based on adjusted FDR
 p-values and can highlight specific genes provided in \code{genevec}.
  \item \code{"groups"}: The plot highlights predefined groups, such as
 "Attenuated" and "Outgroup", within the data.
}

If \code{plot = TRUE}, the plot is displayed interactively. If
 \code{plot = FALSE}, the plot is saved to a file in the specified format and
 output folder.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating necessary results
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
       showtime = FALSE, verbose = FALSE)
rescountna <- countna(avfilt, expdf, nbcpu = 1, verbose = FALSE)
ecdf <- genesECDF(avfilt, expdf, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]
resmeandiff <- meandifference(resecdf, expdf, nbwindows,
   verbose = FALSE)
bytranslistmean <- split(resmeandiff, factor(resmeandiff$transcript))
resknee <- kneeid(bytranslistmean, expdf, verbose = FALSE)
resauc <- allauc(bytranslistmean, expdf, nbwindows, verbose = FALSE)
resatt <- attenuation(resauc, resknee, rescountna, bytranslistmean, expdf,
       resmeandiff, verbose = FALSE)
resug <- universegroup(resatt, expdf, verbose = FALSE)

## Testing plotauc
plotauc(resug, expdf, plottype = "groups", plot = TRUE)

}
\seealso{
[allauc]
}
