% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{tf_extract_opts}
\alias{tf_extract_opts}
\title{Tensor extract options}
\usage{
tf_extract_opts(
  style = getOption("tensorflow.extract.style"),
  ...,
  one_based = getOption("tensorflow.extract.one_based", TRUE),
  inclusive_stop = getOption("tensorflow.extract.inclusive_stop", TRUE),
  disallow_out_of_bounds = getOption("tensorflow.extract.dissallow_out_of_bounds", TRUE),
  warn_tensors_passed_asis = getOption("tensorflow.extract.warn_tensors_passed_asis",
    TRUE),
  warn_negatives_pythonic = getOption("tensorflow.extract.warn_negatives_pythonic", TRUE)
)
}
\arguments{
\item{style}{one of \code{NULL} (the default) \code{"R"} or \code{"python"}. If supplied,
this overrides all other options. \code{"python"} is equivalent to all the other
arguments being \code{FALSE}. \code{"R"} is equivalent to
\code{warn_tensors_passed_asis} and \code{warn_negatives_pythonic}
set to \code{FALSE}}

\item{...}{ignored}

\item{one_based}{TRUE or FALSE, if one-based indexing should be used}

\item{inclusive_stop}{TRUE or FALSE, if slices like \code{start:stop} should be
inclusive of \code{stop}}

\item{disallow_out_of_bounds}{TRUE or FALSE, whether checks are performed on
the slicing index to ensure it is within bounds.}

\item{warn_tensors_passed_asis}{TRUE or FALSE, whether to emit a warning the
first time a tensor is supplied to \code{[} that tensors are passed as-is, with
no R to python translation}

\item{warn_negatives_pythonic}{TRUE or FALSE, whether to emit
a warning the first time a negative number is supplied to \code{[} about the
non-standard (python-style) interpretation}
}
\value{
an object with class "tf_extract_opts", suitable for passing to
\verb{[.tensorflow.tensor()}
}
\description{
Tensor extract options
}
\examples{
\dontrun{
x <- tf$constant(1:10)

opts <-  tf_extract_opts("R")
x[1, options = opts]

# or for more fine-grained control
opts <- tf_extract_opts(
    one_based = FALSE,
    warn_tensors_passed_asis = FALSE,
    warn_negatives_pythonic = FALSE
)
x[0:2, options = opts]
}
}
