% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tensorflow}
\alias{install_tensorflow}
\title{Install TensorFlow and its dependencies}
\usage{
install_tensorflow(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  envname = "r-tensorflow",
  extra_packages = NULL,
  restart_session = TRUE,
  conda_python_version = NULL,
  ...,
  configure_cudnn = NULL,
  pip_ignore_installed = FALSE,
  new_env = identical(envname, "r-tensorflow"),
  python_version = NULL
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[reticulate:conda_binary]{conda_binary()}} for more details.}

\item{version}{TensorFlow version to install. Valid values include:
\itemize{
\item \code{"default"} installs  2.13
\item \code{"release"} installs the latest release version of tensorflow (which may
be incompatible with the current version of the R package)
\item A version specification like \code{"2.4"} or \code{"2.4.0"}. Note that if the patch
version is not supplied, the latest patch release is installed (e.g.,
\code{"2.4"} today installs version "2.4.2")
\item \code{nightly} for the latest available nightly build.
\item To any specification, you can append "-cpu" to install the cpu version
only of the package (e.g., \code{"2.4-cpu"})
\item The full URL or path to a installer binary or python *.whl file.
}}

\item{envname}{The name, or full path, of the environment in which Python
packages are to be installed. When \code{NULL} (the default), the active
environment as set by the \code{RETICULATE_PYTHON_ENV} variable will be used;
if that is unset, then the \code{r-reticulate} environment will be used.}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{restart_session}{Restart R session after installing (note this will
only occur within RStudio).}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}, depending on the \code{method} used.}

\item{configure_cudnn}{If \code{install_tensorflow()} detects the platform is
Linux, an Nvidia GPU is available, and the TensorFlow version is 2.13 (the
default), it will install also install the pip package
"nvidia-cudnn-cu11==8.6.*", symlink the cudnn ".so" files so they can be
found by tensorflow, and emit instructions for how to install Nvidia
drivers to enable GPU usage.}

\item{pip_ignore_installed}{Whether pip should ignore installed python
packages and reinstall all already installed python packages. This defaults
to \code{TRUE}, to ensure that TensorFlow dependencies like NumPy are compatible
with the prebuilt TensorFlow binaries.}

\item{new_env}{If \code{TRUE}, any existing Python virtual environment and/or
conda environment specified by \code{envname} is deleted first.}

\item{python_version, conda_python_version}{Pass a string like "3.8" to
request that conda install a specific Python version. This is ignored when
attempting to install in a Python virtual environment. Note that the Python
version must be compatible with the requested Tensorflow version,
documented here:
\url{https://www.tensorflow.org/install/pip#system-requirements}}
}
\description{
\code{install_tensorflow()} installs just the tensorflow python package and it's
direct dependencies. For a more complete installation that includes
additional optional dependencies, use \code{\link[keras:install_keras]{keras::install_keras()}}.
}
\details{
You may be prompted to download and install miniconda if reticulate
did not find a non-system installation of python. Miniconda is the
recommended installation method for most users, as it ensures that the R
python installation is isolated from other python installations. All python
packages will by default be installed into a self-contained conda or venv
environment named "r-reticulate". Note that "conda" is the only supported
method on M1 Mac.

If you initially declined the miniconda installation prompt, you can later
manually install miniconda by running \code{\link[reticulate:install_miniconda]{reticulate::install_miniconda()}}.
}
\section{Custom Installation}{
 \code{install_tensorflow()} or
\code{keras::install_keras()} isn't required to use tensorflow with the package.
If you manually configure a python environment with the required
dependencies, you can tell R to use it by pointing reticulate at it,
commonly by setting an environment variable:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{Sys.setenv("RETICULATE_PYTHON" = "~/path/to/python-env/bin/python")
}\if{html}{\out{</div>}}
}

\section{Apple Silicon}{
 Beginning with Tensorflow version 2.13, the default
tensorflow package now works on Apple Silicon. See
\url{https://developer.apple.com/metal/tensorflow-plugin/} for instructions
on how to install older versions of Tensorflow on macOS. Please note that
not all operations are supported on Arm Mac GPUs. You can work around the
missing operations by pinning operations to CPU. For example:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{x <- array(runif(64*64), c(1, 64, 64))
keras::layer_random_rotation(x, .5)  # Error:
# No registered 'RngReadAndSkip' OpKernel for 'GPU' devices
# Pin the operation to the CPU to avoid the error
with(tf$device("CPU"), keras::layer_random_rotation(x, .5) ) # No Error
}\if{html}{\out{</div>}}
}

\section{Additional Packages}{


If you wish to add additional PyPI packages to your Keras / TensorFlow
environment you can either specify the packages in the \code{extra_packages}
argument of \code{install_tensorflow()} or \code{install_keras()}, or alternatively
install them into an existing environment using the
\code{\link[reticulate:py_install]{reticulate::py_install()}} function. Note that \code{install_keras()} includes a
set of additional python packages by default, see \code{?keras::install_keras}
for details.
}

\seealso{
\itemize{
\item \code{\link[keras:install_keras]{keras::install_keras()}}
\item \url{https://tensorflow.rstudio.com/reference/tensorflow/install_tensorflow}
}
}
