% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snippet.R
\name{plot_music}
\alias{plot_music}
\alias{plot_music_tc}
\alias{plot_music_bc}
\alias{plot_music_tab}
\alias{plot_music_guitar}
\alias{plot_music_bass}
\title{Plot sheet music snippet with LilyPond}
\usage{
plot_music(
  music,
  clef = "treble",
  tab = FALSE,
  tuning = "standard",
  string_names = NULL,
  header = NULL,
  paper = NULL,
  colors = NULL,
  res = 300
)

plot_music_tc(music, header = NULL, paper = NULL, colors = NULL, res = 300)

plot_music_bc(music, header = NULL, paper = NULL, colors = NULL, res = 300)

plot_music_tab(
  music,
  clef = NA,
  tuning = "standard",
  string_names = NULL,
  header = NULL,
  paper = NULL,
  colors = NULL,
  res = 300
)

plot_music_guitar(
  music,
  tuning = "standard",
  string_names = NULL,
  header = NULL,
  paper = NULL,
  colors = NULL,
  res = 300
)

plot_music_bass(
  music,
  tuning = "bass",
  string_names = FALSE,
  header = NULL,
  paper = NULL,
  colors = NULL,
  res = 300
)
}
\arguments{
\item{music}{a music object.}

\item{clef}{character, include a music staff with the given clef.
\code{NA} to suppress. See \code{track} for details.}

\item{tab}{logical, include tablature staff. \code{NA} to suppress. See
\code{track}.}

\item{tuning}{character, string tuning, only applies to tablature. See
\code{track}.}

\item{string_names}{label strings at beginning of tab staff. \code{NULL}
(default) for non-standard tunings only, \code{TRUE} or \code{FALSE} for
force on or off completely.}

\item{header}{a named list of arguments passed to the header of the
LilyPond file. See \code{lilypond} details.}

\item{paper}{a named list of arguments for the LilyPond file page layout.
See \code{lilypond} details.}

\item{colors}{a named list of LilyPond element color global overrides. See
\code{lilypond} for details.}

\item{res}{numeric, resolution, png only. Defaults to 300.}
}
\value{
a plot
}
\description{
These functions are wrappers around the \code{render_music_*} functions.
They abstract the process of rendering a sheet music snippet to png and
loading the rendered image back into R to be displayed as a plot in an open
graphics device or inserted into an R markdown code chunk.
}
\details{
While these functions abstract away the details of the process, this is not
the same as making the plot completely in R. R is only displaying the
intermediary png file. LilyPond is required to engrave the sheet music.

For R markdown you can alternatively render the png using the corresponding
\code{render_music_*} function and then place it in the document explicitly
using \code{knitr::include_graphics}. Transparency is not relevant to these
wrapper functions since they are used only for plotting, not for overlays on
existing. See \code{\link{render_music}} for more details.
}
\examples{
x <- "a,4;5*5 b,4- c4 cgc'e'~4 cgc'e'1 e'4;2 c';3 g;4 c;5 ce'1;51"
x <- as_music(x)

y <- "a,,4;3*5 b,,4- c,4 c,g,c~4 c,g,c1 c4;1 g,;2 c,;3 g,;2 c,c1;31"
y <- as_music(y)

\dontrun{
if(tabr_options()$lilypond != ""){ # requires LilyPond installation
  plot_music(x)
  plot_music(x, "treble_8", tab = TRUE)

  plot_music_tc(x)
  plot_music_bc(x)

  plot_music_tab(x)
  plot_music_guitar(x)
  plot_music_bass(y)
}
}
}
\seealso{
\code{render_music}, \code{\link{phrase}}, \code{\link{track}},
\code{\link{score}}, \code{\link{lilypond}}, \code{\link{tab}}
}
