% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{keys}
\alias{keys}
\alias{key_is_natural}
\alias{key_is_sharp}
\alias{key_is_flat}
\alias{key_n_sharps}
\alias{key_n_flats}
\alias{key_is_major}
\alias{key_is_minor}
\title{Key signatures}
\usage{
keys(type = c("all", "sharp", "flat"))

key_is_natural(key)

key_is_sharp(key)

key_is_flat(key)

key_n_sharps(key)

key_n_flats(key)

key_is_major(key)

key_is_minor(key)
}
\arguments{
\item{type}{character, defaults to \code{"all"}.}

\item{key}{character, key signature.}
}
\value{
character vector.
}
\description{
Helper functions for key signature information.
}
\details{
The \code{keys} function returns a vector of valid key signature IDs. These IDs are how key signatures are specified throughout \code{tabr}, including in the other helper functions here via \code{key}.
Like the other functions here, \code{key_is_sharp} and \code{key_is_flat} are for \emph{key signatures}, not single pitches whose sharp or flat status is always self-evident from their notation.
Major and minor keys are also self-evident from their notation, but \code{key_is_major} and \code{key_is_minor} can still be useful when programming.
}
\examples{
keys()
key_is_natural(c("c", "am", "c#"))
x <- c("a", "e_")
key_is_sharp(x)
key_is_flat(x)
key_n_sharps(x)
key_n_flats(x)
}
