% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_SuperLearner_regression.R
\name{continuousSuperLearner}
\alias{continuousSuperLearner}
\title{Function to generate imputations using SuperLearner for data with a continuous outcome}
\usage{
continuousSuperLearner(y, x, wy, SL.library, kernel, bw, bw.update, ...)
}
\arguments{
\item{y}{Vector of observed and missing/imputed values of the variable to be imputed.}

\item{x}{Numeric matrix of variables to be used as predictors in SuperLearner models
with rows corresponding to observed values of the variable to be imputed and
columns corresponding to individual predictor variables.}

\item{wy}{Logical vector. A TRUE value indicates locations in \code{y} that are
missing or imputed.}

\item{SL.library}{Either a character vector of prediction algorithms or a
list containing character vectors. A list of functions included in the
SuperLearner package can be found with \code{SuperLearner::listWrappers()}.}

\item{kernel}{one of \code{gaussian}, \code{uniform}, or \code{triangular}.
Specifies the kernel to be used in estimating the distribution around a missing value.}

\item{bw}{\code{NULL} or numeric value for bandwidth of kernel function (as standard deviations of the kernel).}

\item{bw.update}{logical indicating whether bandwidths should be computed
every iteration or only on the first iteration.  Default is \code{TRUE},
but \code{FALSE} may speed up the run time at the cost of accuracy.}

\item{...}{further arguments passed to \code{SuperLearner()}.}
}
\value{
numeric vector of randomly drawn imputed values.
}
\description{
Function to generate imputations using SuperLearner for data with a continuous outcome
}
