% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov3.R
\name{vcov_CR3J}
\alias{vcov_CR3J}
\title{Compute CRV3 covariance matrices via a cluster
jackknife as described in MacKinnon, Nielsen & Webb
(2022)}
\usage{
vcov_CR3J(obj, ...)
}
\arguments{
\item{obj}{An object of class \code{lm} or \code{fixest}
computed?}

\item{...}{misc function argument}
}
\value{
An object of type 'vcov_CR3J'
}
\description{
Compute CRV3 covariance matrices via a cluster
jackknife as described in MacKinnon, Nielsen & Webb
(2022)
}
\examples{

library(summclust)
data(mtcars)
mtcars

fit <- lm(mpg ~ cyl + disp + hp, data = mtcars)
summ <- vcov_CR3J(fit, cluster = ~carb)
}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
\seealso{
\link[summclust]{vcov_CR3J.lm},
\link[summclust]{vcov_CR3J.fixest}
}
