% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-files.R
\name{transform_file}
\alias{transform_file}
\title{Transform a file and output a customized message}
\usage{
transform_file(
  path,
  fun,
  max_char_path,
  message_before = "",
  message_after = " [DONE]",
  message_after_if_changed = " *",
  ...,
  dry
)
}
\arguments{
\item{path}{A vector with file paths to transform.}

\item{fun}{A function that returns a character vector.}

\item{max_char_path}{The number of characters of the longest path. Determines
the indention level of \code{message_after}.}

\item{message_before}{The message to print before the path.}

\item{message_after}{The message to print after the path.}

\item{message_after_if_changed}{The message to print after \code{message_after} if
any file was transformed.}

\item{...}{Further arguments passed to \code{\link[=transform_utf8]{transform_utf8()}}.}

\item{dry}{To indicate whether styler should run in \emph{dry} mode, i.e. refrain
from writing back to files .\code{"on"} and \code{"fail"} both don't write back, the
latter returns an error if the input code is not identical to the result
of styling. "off", the default, writes back if the input and output of
styling are not identical.}
}
\description{
Transforms file contents and outputs customized messages.
}
\keyword{internal}
