% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing-public-api.R
\name{catch_style_file_output}
\alias{catch_style_file_output}
\title{Capture and post-process the output of \code{style_file} without causing side
effects}
\usage{
catch_style_file_output(file_in = c("public-api", "xyzdir-dirty",
  "dirty-sample-with-scope-tokens.R"), encoding)
}
\arguments{
\item{file_in}{A vector passed to \code{\link[=testthat_file]{testthat_file()}} to construct the path
to the reference file.}
}
\value{
A character vector with the captured output of \code{\link[=style_file]{style_file()}} called on
\code{file_in} ran in a temp dir to avoid side effects on the input file (because
the next time the test would ran, the file would not need styling). The
styling is carried out with a temporary working directory change to keep
filenames relative and avoid portability issues in the exact output
comparison which is needed when the system that runs the unit testing (CI)
is a different system than the one that created the reference value.
This also implies that the ruler width, which depend on the path
length, will again have the same width on all systems and is independent of
how many characters the path of the temporary directory has.
}
\description{
Capture and post-process the output of \code{style_file} without causing side
effects
}
\keyword{internal}
