% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_guides.R
\name{create_style_guide}
\alias{create_style_guide}
\title{Create a style guide}
\usage{
create_style_guide(initialize = default_style_guide_attributes,
  line_break = NULL, space = NULL, token = NULL, indention = NULL,
  use_raw_indention = FALSE, reindention = tidyverse_reindention())
}
\arguments{
\item{initialize}{The bare name of a function that initializes various
variables on each level of nesting.}

\item{line_break}{A list of transformer functions that manipulate line_break
information.}

\item{space}{A list of transformer functions that manipulate spacing
information.}

\item{token}{A list of transformer functions that manipulate token text.}

\item{indention}{A list of transformer functions that manipulate indention.}

\item{use_raw_indention}{Boolean indicating whether or not the raw indention
should be used.}

\item{reindention}{A list of parameters for regex re-indention, most
conveniently constructed using \code{\link[=specify_reindention]{specify_reindention()}}.}
}
\description{
This is a helper function to create a style guide, which is technically
speaking a named list of groups of transformer functions where each
transformer function corresponds to one styling rule. The output of this
function can be used as an argument for \code{style} in top level functions
like \code{\link[=style_text]{style_text()}} and friends.
}
\examples{
set_line_break_before_curly_opening <- function(pd_flat) {
  op <- pd_flat$token \%in\% "'{'"
  pd_flat$lag_newlines[op] <- 1L
  pd_flat
}
set_line_break_before_curly_opening_style <- function() {
  create_style_guide(line_break = set_line_break_before_curly_opening)
}
style_text("a <- function(x) { x }", style = set_line_break_before_curly_opening_style)
}
