% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{str_equal}
\alias{str_equal}
\title{Determine if two strings are equivalent}
\usage{
str_equal(x, y, locale = "en", ignore_case = FALSE, ...)
}
\arguments{
\item{x, y}{A pair of character vectors.}

\item{locale}{Locale to use for comparisons. See
\code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}} for all possible options.
Defaults to "en" (English) to ensure that default behaviour is
consistent across platforms.}

\item{ignore_case}{Ignore case when comparing strings?}

\item{...}{Other options used to control collation. Passed on to
\code{\link[stringi:stri_opts_collator]{stringi::stri_opts_collator()}}.}
}
\value{
An logical vector the same length as \code{x}/\code{y}.
}
\description{
This uses Unicode canonicalisation rules, and optionally ignores case.
}
\examples{
# These two strings encode "a" with an accent in two different ways
a1 <- "\u00e1"
a2 <- "a\u0301"
c(a1, a2)

a1 == a2
str_equal(a1, a2)

# ohm and omega use different code points but should always be treated
# as equal
ohm <- "\u2126"
omega <- "\u03A9"
c(ohm, omega)

ohm == omega
str_equal(ohm, omega)
}
\seealso{
\code{\link[stringi:stri_compare]{stringi::stri_cmp_equiv()}} for the underlying implementation.
}
