% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{resetRandomEffectsModel}
\alias{resetRandomEffectsModel}
\title{Reset a \code{RandomEffectsModel} object based on the parameters indexed by \code{sample_num} in a \code{RandomEffectsSamples} object}
\usage{
resetRandomEffectsModel(rfx_model, rfx_samples, sample_num, sigma_alpha_init)
}
\arguments{
\item{rfx_model}{Object of type \code{RandomEffectsModel}.}

\item{rfx_samples}{Object of type \code{RandomEffectSamples}.}

\item{sample_num}{Index of sample stored in \code{rfx_samples} from which to reset the state of a random effects model. Zero-indexed, so resetting based on the first sample would require setting \code{sample_num = 0}.}

\item{sigma_alpha_init}{Initial value of the "working parameter" scale parameter.}
}
\value{
None
}
\description{
Reset a \code{RandomEffectsModel} object based on the parameters indexed by \code{sample_num} in a \code{RandomEffectsSamples} object
}
\examples{
n <- 100
p <- 10
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- matrix(rep(1.0, n), ncol=1)
rfx_dataset <- createRandomEffectsDataset(rfx_group_ids, rfx_basis)
y <- (-2*(rfx_group_ids==1)+2*(rfx_group_ids==2)) + rnorm(n)
y_std <- (y-mean(y))/sd(y)
outcome <- createOutcome(y_std)
rng <- createCppRNG(1234)
num_groups <- length(unique(rfx_group_ids))
num_components <- ncol(rfx_basis)
rfx_model <- createRandomEffectsModel(num_components, num_groups)
rfx_tracker <- createRandomEffectsTracker(rfx_group_ids)
rfx_samples <- createRandomEffectSamples(num_components, num_groups, rfx_tracker)
alpha_init <- rep(1,num_components)
xi_init <- matrix(rep(alpha_init, num_groups),num_components,num_groups)
sigma_alpha_init <- diag(1,num_components,num_components)
sigma_xi_init <- diag(1,num_components,num_components)
sigma_xi_shape <- 1
sigma_xi_scale <- 1
rfx_model$set_working_parameter(alpha_init)
rfx_model$set_group_parameters(xi_init)
rfx_model$set_working_parameter_cov(sigma_alpha_init)
rfx_model$set_group_parameter_cov(sigma_xi_init)
rfx_model$set_variance_prior_shape(sigma_xi_shape)
rfx_model$set_variance_prior_scale(sigma_xi_scale)
for (i in 1:3) {
    rfx_model$sample_random_effect(rfx_dataset=rfx_dataset, residual=outcome, 
                                   rfx_tracker=rfx_tracker, rfx_samples=rfx_samples, 
                                   keep_sample=TRUE, global_variance=1.0, rng=rng)
}
resetRandomEffectsModel(rfx_model, rfx_samples, 0, 1.0)
}
