% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.lc.mean.bs}
\alias{ci.lc.mean.bs}
\title{Confidence interval for a linear contrast of means in a between-subjects
design}
\usage{
ci.lc.mean.bs(alpha, m, sd, n, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{vector of estimated group means}

\item{sd}{vector of estimated group standard deviations}

\item{n}{vector of sample sizes}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated linear contrast
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a test statistic and confidence interval for a linear contrast
of means in a between-subjects design. This function computes both unequal
variance and equal variance confidence intervals and test statistics. A
Satterthwaite adjustment to the degrees of freedom is used with the
unequal variance method.
}
\examples{
m <- c(33.5, 37.9, 38.0, 44.1)
sd <- c(3.84, 3.84, 3.65, 4.98)
n <- c(10,10,10,10)
v <- c(.5, .5, -.5, -.5)
ci.lc.mean.bs(.05, m, sd, n, v)

# Should return:
#                              Estimate       SE         t       df 
# Equal Variances Assumed:        -5.35 1.300136 -4.114955 36.00000 
# Equal Variances Not Assumed:    -5.35 1.300136 -4.114955 33.52169 
#                                         p         LL        UL
# Equal Variances Assumed:     0.0002152581  -7.986797 -2.713203
# Equal Variances Not Assumed: 0.0002372436  -7.993583 -2.706417


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
