% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srppp-xml.R
\name{srppp_xml_get_products}
\alias{srppp_xml_get_products}
\title{Get Products from an XML version of the Swiss Register of Plant Protection Products}
\usage{
srppp_xml_get_products(
  srppp_xml = srppp_xml_get(),
  verbose = TRUE,
  remove_duplicates = TRUE
)
}
\arguments{
\item{srppp_xml}{An object as returned by 'srppp_xml_get'}

\item{verbose}{Should we give some feedback?}

\item{remove_duplicates}{Should duplicates based on wNbrs be removed? If set
to 'TRUE', one of the two entries with identical wNbrs is removed, based on
an investigation of background information carried out by the package authors.
In all cases except for one, one of the product sections with duplicate wNbrs
has information about an expiry of the registration, and the other doesn't.
In these cases the registration without expiry is kept, and the expiring
registration is discarded. In the remaining case (wNbr 5945), the second
entry is selected, as it contains more indications which were apparently
intended to be published as well.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with a row for each product section
in the XML file. An attribute 'duplicated_wNbrs' is
also returned, containing duplicated W-Numbers, if applicable,
or NULL.
}
\description{
Get Products from an XML version of the Swiss Register of Plant Protection Products
}
\examples{
# Try to get current list of products
\donttest{
try(srppp_xml_get_products())
}
}
