% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GridData.R
\name{subset_Grid}
\alias{subset_Grid}
\title{Subgrid by selection of levels in one dimension.}
\usage{
subset_Grid(X, subset, type = c("index", "Grid", "both"), drop = TRUE)
}
\arguments{
\item{X}{An object with class \code{"Grid"}.}

\item{subset}{An expression concerning \emph{one} of the dimension of \code{X}.
This can be compared to an expression in the \code{subset} method.}

\item{type}{The wanted type of result. When \code{type} is
\code{"index"}, the returned result is an integer vector
containing the indices of the subgrid nodes in the original
grid. When \code{type} is \code{"Grid"} the result is the subgrid
as an object of this class. Finally when \code{type} is
\code{"both"} a list is returned containing the two previous types
of result under the names \code{index} and \code{Grid}.}

\item{drop}{Logical. If \code{TRUE} and if only one level is selected
with \code{subset} then the corresponding dimension of the (flat)
\code{Grid} result will be dropped.}
}
\value{
A vector of integer indices, a \code{Grid} object or a list
embedding these two elements, depending on the value of \code{type}.
}
\description{
Subgrid by selection of levels in one dimension.
}
\note{
The new \code{Grid} returned (if any) uses consecutive
numbers for the nodes between \eqn{1} and the number of new nodes. So it
no longer keeps trace of the nodes position in \code{X}.  However
the surviving nodes are kept in the order that they had in
\code{X}.

When a response vector or matrix say \code{Y} is related to the
original grid \code{X}, the index vector returned by
\code{subgrid} can be used to select the corresponding responses.
}
\examples{
myGD <- Grid(levels = list("Temp" = c(250, 260, 280, 290, 300),
                           "Press" = c(3, 4, 6, 10)))
myGD2 <- subset_Grid(myGD, subset = Temp > 280)
}
\seealso{
The \code{\link{subset}} method.
}

