% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circles.plot.R
\name{circles.plot}
\alias{circles.plot}
\title{Plot circles}
\usage{
circles.plot(coords, r, add = FALSE, ..., nv = 100, border = NULL,
  ccol = NA, clty = 1, density = NULL, angle = 45, clwd = 1)
}
\arguments{
\item{coords}{A matrix of coordinates with the centroid
of each circle.}

\item{r}{A vector containing the radii of the circles. 
The length of \code{r} must equal the number of rows of
\code{coords}.}

\item{add}{A logical value indicating whether the circles
should be added to an existing plot.  Default is
\code{FALSE}.}

\item{...}{Additional arguments passed to the 
\code{\link[graphics]{plot}} function.}

\item{nv}{Number of vertices to draw the circle.}

\item{border}{A vector with the desired border of each
circle.  The length should either be 1 (in which case
the border is repeated for all circles) or should match
the number of rows of \code{coords}.}

\item{ccol}{A vector with the desired color of each
circle.  The length should either be 1 (in which case
the color is repeated for all circles) or should match
the number of rows of \code{coords}.}

\item{clty}{A vector with the desired line type of each
circle.  The length should either be 1 (in which case
the line type is repeated for all circles) or should match
the number of rows of \code{coords}.}

\item{density}{A vector with the density for a patterned fill.
The length should either be 1 (in which case
the density is repeated for all circles) or should match
the number of rows of \code{coords}. See \code{\link[graphics]{polygon}}}

\item{angle}{A vector with the angle of a patterned fill.
The length should either be 1 (in which case
the angle is repeated for all circles) or should match
the number of rows of \code{coords}. See \code{\link[graphics]{polygon}}}

\item{clwd}{A vector with the desired line width of each
circle.  The length should either be 1 (in which case
the line width is repeated for all circles) or should match
the number of rows of \code{coords}.}
}
\description{
\code{plot.circles} creates a plot with one or more 
circles (or adds them to an existing plot).
}
\examples{
co = cbind(c(1, 2, 5, 6, 9), c(1, 2, 5, 6, 9))
r = c(1.25, 1.25, 1.25, 1.25, 1.25)
# draw circles
circles.plot(co, r)
circles.plot(co, r, 
   ccol = c("blue", "blue", "orange", "orange", "brown"),
   density = c(10, 20, 30, 40, 50),
   angle = c(45, 135, 45, 136, 90))
}
\seealso{
\code{\link[plotrix]{draw.circle}}, \code{\link[graphics]{polygon}}
}
\author{
Joshua French
}
