% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spscan.test.R
\name{spscan.test}
\alias{spscan.test}
\title{Spatial Scan Test}
\usage{
spscan.test(x, case = 2, nsim = 499, alpha = 0.1, nreport = nsim + 1,
  maxd = NULL)
}
\arguments{
\item{x}{A \code{ppp} object from the \code{spatstat} package with marks for the case and control groups.}

\item{case}{The position of the name of the "case" group in levels(x$marks).  The default is 2.}

\item{nsim}{The number of simulations from which to compute p-value.}

\item{alpha}{The significance level to determine whether a cluster is signficiant.}

\item{nreport}{The frequency with which to report simulation progress.  The default is \code{nsim+ 1}, meaning no progress will be displayed.}

\item{maxd}{The radius of the largest possible cluster to consider.}
}
\value{
Returns a list with the following components:
\item{coords}{The centroids of the significant clusters.}
\item{r}{The radii of the window of the significant clusters.}
\item{p}{The vector of p-values associated with the significant clusters.}
\item{ppp}{The original ppp object for which the scan test was performed.}
}
\description{
\code{spscan.test} performs the spatial scan test of Kulldorf (1997).
}
\details{
The test is performed using the random labeling hypothesis.  The windows are circular and extend from the observed data locations.  The clusters returned are non-overlapping, ordered from most significant to least significant.  The first cluster is the most likely to be a cluster.  If no significant clusters are found, then the most likely is returned (along with a warning).
}
\examples{
data(grave)
out = spscan.test(grave)
plot(out, main = "")
# get warning if no significant cluster
out2 = spscan.test(grave, alpha = 0.01)
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kulldorff, M. (1997) A spatial scan statistic. Communications in Statistics -- Theory and Methods 26, 1481-1496.
}

