% Generated by roxygen2 (4.0.2): do not edit by hand
\name{logrr.test}
\alias{logrr.test}
\title{Global test of clustering using log ratio of spatial densities}
\usage{
logrr.test(x)
}
\arguments{
\item{x}{An \code{renv} object from the \code{logrr.env} function.}
}
\value{
A list providing the observed test statistic (\code{islogrr}) and the estimated p-value {\code{pvalue}}.
}
\description{
\code{logrr.test} performs a global test of clustering for comparing cases and controls using the log ratio of spatial densities the method of Kelsall and Diggle (1995).
}
\examples{
data(grave)
renv = logrr(grave, nsim = 9)
logrr.test(renv)
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kelsall, Julia E., and Peter J. Diggle. "Non-parametric estimation of spatial variation in relative risk." Statistics in Medicine 14.21-22 (1995): 2335-2342.
}

