% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{area}
\alias{area}
\title{Calculate the area covered by the given slendr object}
\usage{
area(x)
}
\arguments{
\item{x}{Object of the class \code{slendr}}
}
\value{
Area covered by the input object. If a \code{slendr_pop}
was given, a table with an population range area in each time
point will be returned. If a \code{slendr_region} or
\code{slendr_world} object was specified, the total area covered
by this object's spatial boundary will be returned.
}
\description{
Calculate the area covered by the given slendr object
}
\examples{
region_a <- region("A", center = c(20, 50), radius = 20)
region_b <- region("B", polygon = list(c(50, 40), c(70, 40), c(70, 60), c(50, 60)))
plot_map(region_a, region_b)

# note that area won't be *exactly* equal to pi*r^2:
#   https://stackoverflow.com/a/65280376
area(region_a)

area(region_b)
}
