% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{time2jd}
\alias{time2jd}
\title{Converts date and time (in any timezone) to Julian date}
\usage{
time2jd(time, timezone, calendar, verbose = F)
}
\arguments{
\item{time}{String containing the date and time in the format "YYYY/MM/DD HH:MM:SS". BCE dates
should use negative sign. Use \code{\link{timestring}} if needed.}

\item{timezone}{(Optional) Timezone of input either as a known acronym (e.g. "GMT", "CET") or
a string with continent followed by country capital (e.g. "Europe/London"). See
\code{\link{timezones}} for details. Default is the system timezone}

\item{calendar}{(Optional) Calendar used in parameter \emph{time}. G for gregorian and J for julian.
Defaults to \emph{Gregorian}.}

\item{verbose}{(Optional) Controls whether messages should be displayed. Default is \emph{FALSE}.}
}
\description{
Converts date and time (in any timezone) to Julian date
}
\examples{
# Julian date at noon GMT on Christmas day 2018
time2jd('2018/12/25 12:00:00', 'GMT')
}
\seealso{
\code{\link[swephR]{swe_julday}}, \code{\link{as.POSIXlt}}, \code{\link{timezones}},
\code{\link{timestring}}
}
