% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_tools.R
\name{add_file_in_dir}
\alias{add_file_in_dir}
\alias{edit_file_in_dir}
\alias{suppress_file_in_dir}
\alias{get_yaml_info}
\title{Add / suppress / edit a file}
\usage{
add_file_in_dir(
  file,
  dir,
  yml,
  name,
  description = "",
  date_time_format = "\%Y\%m\%d_\%H\%M\%s"
)

edit_file_in_dir(
  id,
  dir,
  yml,
  name = NULL,
  description = NULL,
  file = NULL,
  date_time_format = "\%Y\%m\%d_\%H\%M\%s"
)

suppress_file_in_dir(id, dir, yml)

get_yaml_info(
  yml,
  recorded_name = TRUE,
  date_time_format = "\%Y\%m\%d_\%H\%M\%s",
  add_img = FALSE,
  img_size = 30
)
}
\arguments{
\item{file}{\code{character} file (to copy) path.}

\item{dir}{\code{character} directory path.}

\item{yml}{\code{character} yaml configuration file full path.}

\item{name}{\code{character} file name.}

\item{description}{\code{character} file description.}

\item{date_time_format}{\code{character} DateTime format.}

\item{id}{\code{character} file id in yaml.}

\item{recorded_name}{\code{logical} : add recorded name (with date_time extension) in output ?}

\item{add_img}{\code{logical} : Use in shiny module for adding file extension img.}

\item{img_size}{\code{integer} : Use in shiny module for adding file extension img.}
}
\value{
These functions return a \code{logical} indicating if operation succeeded or not
}
\description{
Add / suppress / edit a file
}
\examples{
\dontrun{

yml <- file.path(getwd(), "test_sfm/config.yml") # will be created

dir <- file.path(getwd(), "test_sfm")
dir.create(dir)

file <- system.file("translate/translate.csv", package = "shinydrive")

# add one first file
add_file_in_dir(
  file = file,
  dir = dir,
  yml = yml,
  name = "translate1",
  description = ""
)

yaml::yaml.load_file(yml)
list.files(dir)
get_yaml_info(yml)

# add second file
add_file_in_dir(
  file = file,
  dir = dir,
  yml = yml,
  name = "translate_2",
  description = "This is cool"
)

yaml::yaml.load_file(yml)
list.files(dir)
get_yaml_info(yml, recorded_name = F)

# modify first file
edit_file_in_dir(
  id = "2", 
  dir = dir, 
  yml = yml,
  name = "translate_2_mod",
  description = "So cool"
)

yaml::yaml.load_file(yml)
list.files(dir)

# suppress first file
suppress_file_in_dir(id = "1", dir = dir, yml = yml)

yaml::yaml.load_file(yml)
list.files(dir)

}

}
